
# line 4 "el_syn.y"

#include "elcom.h"

extern struct typliste *defs;                /* elcom.c */
extern struct ausdruck *prog;                /* elcom.c */

extern char fname[85];                       /* elcom.c */

int syntaxerror = 0;

char *fehler1 = "\"%s\" line %d: ";
char *fehler2 = "Constructor \"%s\" not ";
char *fehler3 = "found in type declaration \n";


# line 20 "el_syn.y"
typedef union  {
    struct typliste  *typzeiger;
    struct sumliste  *sumzeiger;
    struct prodliste *prodzeiger;
    struct ausdruck  *auszeiger;
    struct defliste  *defzeiger;
    char             *val;
} YYSTYPE;
# define _TYPE 257
# define _END 258
# define _LAMBDA 259
# define _IF 260
# define _THEN 261
# define _ELSE 262
# define _CASE 263
# define _OF 264
# define _ARROW 265
# define _FAIL 266
# define _FATBAR 267
# define _CONSTRUCT 268
# define _SELECT 269
# define _LET 270
# define _IN 271
# define _LETREC 272
# define _SCHEMVAR 273
# define _CONSTRUCTOR 274
# define _IDENTIFIER 275
# define _INTEGER 276
# define _REAL 277
# define _CHAR 278
# define _STRING 279
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 203 "el_syn.y"


#include "lex.yy.c"

struct typliste *app_typ (p, q)
struct typliste *p, *q;
{
    struct typliste *r;

    r = p;
    if (r == NULL)
        return q;
    while (r->next != NULL)
        r = r->next;
    r->next = q;
    return p;
} /* app_typ */

int len_sum (p)
struct sumliste *p;
{
    int i;

    i = 0;
    while (p != NULL) {
        i++;
        p = p->next;
    }
    return i;
} /* len_sum */

int len_prod (p)
struct prodliste *p;
{
    int i;

    i = 0;
    while (p != NULL) {
        i++;
        p = p->next;
    }
    return i;
} /* len_prod */

struct typliste *b_typ (op, var, sum)
char             *op;
struct prodliste *var;
struct sumliste  *sum;
{
    struct typliste *r;

    r = (struct typliste *) new(TYPLISTE);
    r->zeile = yylineno;
    r->typop = op;
    r->konstanz = len_sum(sum);
    r->schemanz = len_prod(var);
    r->vars = var;
    r->typen = sum;
    r->next = NULL;
    return r;
} /* b_typ */

struct sumliste *app_sum (p, q)
struct sumliste *p, *q;
{
    struct sumliste *r;

    r = p;
    if (r == NULL)
        return q;
    while (r->next != NULL)
        r = r->next;
    r->next = q;
    return p;
} /* app_sum */

struct sumliste *b_sum (k, prod)
char             *k;
struct prodliste *prod;
{
    struct sumliste *p;

    p = (struct sumliste *) new(SUMLISTE);
    p->begzeile = yylineno;
    p->kons = k;
    p->stell = len_prod(prod);
    p->prodtypen = prod;
    p->next = NULL;
    return p;
} /* b_sum */

struct prodliste *app_prod (p, q)
struct prodliste *p, *q;
{
    struct prodliste *r;

    r = p;
    if (r == NULL)
        return q;
    while (r->next != NULL)
        r = r->next;
    r->next = q;
    return p;
} /* app_prod */

struct prodliste *b_prod (c, p)
char             *c;
struct prodliste *p;
{
    struct prodliste *r;

    r = (struct prodliste *) new(PRODLISTE);
    r->name = c;
    r->nr = 0;
    r->typ = NULL;
    r->belegung = p;
    r->next = NULL;
    return r;
} /* b_prod */


struct ausdruck *b_konst(ausart,typ,konstwert)
int  ausart,typ;
char *konstwert;
{
    struct ausdruck *p;

    p = (struct ausdruck *) new(AUSDRUCK);
    p->art = ausart;
    p->beginn = yylineno;
    p->strikt = 0;
    p->definition = NULL;
    p->stelligkeit = 0;
    p->standardtyp = typ;
    p->wert = konstwert;
    p->links = p->rechts = p->hinten = NULL;
    return p;
} /* b_konst */

struct ausdruck *b_anw (ausart, aus1, aus2)
int             ausart;
struct ausdruck *aus1, *aus2;
{
    struct ausdruck *p;

    p = (struct ausdruck *) new(AUSDRUCK);
    p->art = ausart;
    p->beginn = yylineno;
    p->strikt = 0;
    p->definition = NULL;
    p->stelligkeit = 0;
    p->standardtyp = 0;
    p->wert = NULL;
    p->links = aus1;
    p->rechts = aus2;
    p->hinten = NULL;
    return p;
} /* b_anw */

int len_def (p)
struct defliste *p;
{
    int i;

    i = 0;
    while (p != NULL) {
        i++;
        p = p->next;
    }
    return i;
} /* len_def */

struct ausdruck *b_lambda(vars, aus)
struct defliste *vars;
struct ausdruck *aus;
{
    struct ausdruck *p;

    p = (struct ausdruck *) new(AUSDRUCK);
    p->art = LAMBDA;
    p->beginn = yylineno;
    p->strikt = 0;
    p->definition = vars;
    p->stelligkeit = len_def(vars);
    p->standardtyp = 0;
    p->wert = NULL;
    p->links = aus;
    p->rechts = p->hinten = NULL;
    return p;
} /* b_lambda */

struct ausdruck *b_if(aus1, aus2, aus3)
struct ausdruck *aus1, *aus2, *aus3;
{
    struct ausdruck *p;

    p = (struct ausdruck *) new(AUSDRUCK);
    p->art = IF;
    p->beginn = yylineno;
    p->strikt = 0;
    p->definition = NULL;
    p->stelligkeit = 0;
    p->standardtyp = 0;
    p->wert = NULL;
    p->links = aus1;
    p->rechts = aus2;
    aus2->hinten = aus3;
    p->hinten = NULL;
    return p;
} /* b_if */

int findekonst (t, c)
struct typliste *t;
char            *c;
{
    struct sumliste *p;
    int             i;

    p = t->typen;
    i = 1;
    while (p != NULL & strcmp(p->kons,c)) {
        i++;
        p = p->next;
    }
    if (p != NULL)
        return i;
    return 0;
} /* findekonst */

struct typliste *findetyp (c)
char *c;
{
    struct typliste *t;

    t = defs;
    while (t != NULL) {
        if (findekonst(t,c))
            break;
        t = t->next;
    }
    return t;
} /* findetyp */

struct ausdruck *b_case (aus1, aus2)
struct ausdruck *aus1, *aus2;
{
    struct typliste *t;
    struct ausdruck *a, *p, *pp;

    p = (struct ausdruck *) new(AUSDRUCK);
    p->art = CASE;
    p->beginn = yylineno;
    p->strikt = 0;
    p->definition = NULL;
    p->stelligkeit = 0;
    p->standardtyp = 0;
    p->wert = NULL;
    p->links = aus1;
    p->rechts = aus2;
    p->hinten = NULL;
    a = p->rechts;
    if ((t = findetyp(a->wert)) == NULL) {
        fprintf(stderr,fehler1,fname,a->beginn);
        fprintf(stderr,fehler2,a->wert);
        fputs(fehler3,stderr);
        syntaxerror = 1;
        return p;
    }
    while (a != NULL) {
        if ((a->standardtyp = findekonst(t,a->wert))
            == 0) {
            fprintf(stderr,fehler1,fname,a->beginn);
            fprintf(stderr,fehler2,a->wert);
            fputs("defined in type \"",stderr);
            fputs(t->typop,stderr);
            fputs("\" \n",stderr);
            syntaxerror = 1;
        }
        pp = p->rechts;
        while (pp != NULL &&
               pp->standardtyp != a->standardtyp)
            pp = pp->hinten;
        if (pp != NULL && pp != a) {
            fprintf(stderr,fehler1,fname,a->beginn);
            fputs("Constructor \"",stderr);
            fputs(a->wert,stderr);
            fputs("\" occurs twice in CASE \n",stderr);
            syntaxerror = 1;
        }
        a = a->hinten;
    }
    return p;
} /* b_case */

struct ausdruck *b_cons (name, aus)
char            *name;
struct ausdruck *aus;
{
    struct typliste *t;
    struct ausdruck *p;

    p = (struct ausdruck *) new(AUSDRUCK);
    p->art = CONS;
    p->beginn = yylineno;
    p->strikt = 0;
    p->definition = NULL;
    p->stelligkeit = 0;
    if ((t = findetyp(name)) == NULL) {
        fprintf(stderr,fehler1,fname,yylineno);
        fprintf(stderr,fehler2,name);
        fputs(fehler3,stderr);
        syntaxerror = 1;
    }
    else
        p->standardtyp = findekonst(t,name);
    p->wert = name;
    p->links = aus;
    p->rechts = p->hinten = NULL;
    return p;
} /* b_cons */

struct ausdruck *b_sel (index, aus)
char            *index;
struct ausdruck *aus;
{
    struct ausdruck *p;

    p = (struct ausdruck *) new(AUSDRUCK);
    p->art = SELECT;
    p->beginn = yylineno;
    p->strikt = 0;
    p->definition = NULL;
    p->stelligkeit = 0;
    p->standardtyp = INTEGER;
    p->wert = index;
    p->links = aus;
    p->rechts = p->hinten = NULL;
    return p;
} /* b_sel */

struct ausdruck *b_let (art, defs, aus)
int             art;
struct defliste *defs;
struct ausdruck *aus;
{
    struct ausdruck *p;

    p = (struct ausdruck *) new(AUSDRUCK);
    p->art = art;
    p->beginn = yylineno;
    p->strikt = 0;
    p->definition = defs;
    p->stelligkeit = len_def(defs);
    p->standardtyp = 0;
    p->wert = NULL;
    p->links = aus;
    p->rechts = p->hinten = NULL;
    return p;
} /* b_let */

struct ausdruck *b_fall (kons, vars, aus)
char            *kons;
struct defliste *vars;
struct ausdruck *aus;
{
    struct ausdruck *p;

    p = (struct ausdruck *) new(AUSDRUCK);
    p->art = MUSTER;
    p->beginn = yylineno;
    p->definition = vars;
    p->stelligkeit = len_def(vars);
    p->standardtyp = -1;
    p->wert = kons;
    p->links = aus;
    p->rechts = p->hinten = NULL;
    return p;
} /* b_fall */

struct defliste *app_def (p, q)
struct defliste *p, *q;
{
    struct defliste *r;

    r = p;
    if (r == NULL)
        return q;
    while (r->next != NULL)
        r = r->next;
    r->next = q;
    return p;
} /* app_def */

struct defliste *b_def (var, wert)
char            *var;
struct ausdruck *wert;
{
    struct defliste *p;

    p = (struct defliste *) new(DEFLISTE);
    p->varname = var;
    p->defstrikt = 0;
    p->sym = NULL;
    p->varwert = wert;
    p->abst = NULL;
    p->next = NULL;
    return p;
} /* b_def */

struct ausdruck *app_ausl (p, q)
struct ausdruck *p, *q;
{
    struct ausdruck *r;

    r = p;
    if (r == NULL)
        return q;
    while (r->hinten != NULL)
        r = r->hinten;
    r->hinten = q;
    return p;
} /* app_ausl */

struct ausdruck *b_str (s)
char *s;
{
    struct ausdruck *p, *pp;
    char            *c;

    if (*s == '\0')
        return b_cons("NIL",NULL);
    c = new(4);
    if (*s == '\\')
        s++;
    c[0] = '\'';
    c[1] = *s;
    c[2] = '\'';
    c[3] = '\0';
    p = b_konst(KONST,CHAR,c);
    pp = b_str(s+1);
    return b_cons("CONS",app_ausl(p,pp));
} /* b_str */

struct ausdruck *b_string (s)
char *s;
{
    struct ausdruck *p;

    s[strlen(s)-1] = '\0';
    p = b_str(s+1);
    free(s);
    return p;
} /* b_string */

fehler (zeile, name)
int  zeile;
char *name;
{
    fprintf(stderr,fehler1,fname,zeile);
    fprintf(stderr,"Type/constructor \"%s\" ",name);
    fputs("declared twice \n",stderr);
    syntaxerror = 1;
} /* fehler */

struct defliste *nachsehen (zeile, name, p)
int             zeile;
char            *name;
struct defliste *p;
{
    struct defliste *r;

    r = p;
    while (r != NULL && strcmp(r->varname,name))
        r = r->next;
    if (r != NULL) {
        fehler(zeile,name);
        return p;
    }
    r = (struct defliste *) new(DEFLISTE);
    r->varname = name;
    r->next = p;
    return r;
} /* nachsehen */

int ueberpruefe (typen)
struct typliste *typen;
{
    struct defliste *p, *q;
    struct typliste *t;
    struct sumliste *s;

    p = NULL;
    t = typen;
    while (t != NULL) {
        p = nachsehen(t->zeile,t->typop,p);
        s = t->typen;
        while (s != NULL) {
            p = nachsehen(s->begzeile,s->kons,p);
            s = s->next;
        }
        t = t->next;
    }
    while (p != NULL) {
        q = p->next;
        free(p);
        p = q;
    }
} /* ueberpruefe */

int analyse (f)
FILE *f;
{
    yyin = f;
    if (yyparse() != 0)
        return 1;
    return syntaxerror;
} /* analyse */

yywrap ()
{
    return 1;
} /* yywrap */

yyerror (s)
char *s;
{
    fprintf(stderr,fehler1,fname,yylineno);
    fputs(s,stderr);
    putc('\n',stderr);
    syntaxerror = 1;
} /* yyerror */
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 24,
	61, 8,
	-2, 0,
-1, 29,
	265, 37,
	41, 37,
	46, 37,
	-2, 0,
-1, 44,
	61, 8,
	-2, 0,
-1, 69,
	265, 46,
	-2, 0,
-1, 80,
	258, 16,
	59, 16,
	124, 16,
	-2, 0,
-1, 87,
	41, 46,
	-2, 0,
-1, 97,
	258, 16,
	59, 16,
	124, 16,
	41, 16,
	-2, 0,
-1, 109,
	41, 16,
	-2, 0,
	};
# define YYNPROD 54
# define YYLAST 268
yytabelem yyact[]={

    11,    31,    38,    25,    54,   109,    87,    81,    68,    46,
    53,    57,    55,   114,   104,    51,    52,    84,   110,    94,
    30,    37,    24,    93,    11,    80,    45,    85,    83,    41,
     3,    95,   100,    21,    96,    78,    71,    88,    60,    66,
    56,    86,    26,    39,    58,    32,    33,    42,    49,    99,
    43,    72,    73,    22,   115,   111,   106,    47,    48,    90,
    82,    62,    35,    34,    27,    40,     1,    89,    67,    29,
    97,    79,    23,     2,    44,     0,     0,     0,     0,    63,
    64,    28,    65,     0,    36,     0,    74,    75,    76,     0,
     0,     0,     0,     0,    44,    61,    59,    50,     0,     0,
     0,     0,    77,    91,    92,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   101,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   103,   102,     0,   105,     0,
     0,   107,   108,     0,     0,   112,     0,     0,     0,     0,
     0,     0,     0,     0,   113,   116,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    20,     4,     0,    13,
    14,     0,     0,    15,    70,     0,     9,    12,    16,    17,
    18,     0,    19,     0,     0,    10,     5,     6,     7,     8,
    20,     0,    69,    13,    14,     0,     0,    15,    46,     0,
     9,    12,    16,    17,    18,     0,    19,     0,     0,    10,
     5,     6,     7,     8,     0,    45,     0,    98 };
yytabelem yypact[]={

   -40, -1000,   -16, -1000,  -253, -1000, -1000, -1000, -1000, -1000,
 -1000,   -16,    24,  -255,   -16,   -16,    23,    22,  -254,  -254,
 -1000, -1000,  -229,   -12,  -247, -1000,   -16,   -16,     2,  -255,
 -1000, -1000,  -246,  -248,  -264,  -272,  -259,   -21, -1000,  -260,
   -15, -1000,  -253,   -23,  -247, -1000, -1000,    20,   -16,   -16,
 -1000,   -16,   -32,     7,     8,   -16,   -16,   -16,  -254, -1000,
  -249, -1000, -1000,    19,  -230,  -245,  -231,   -18,  -268,  -255,
 -1000,    18,   -16,   -16,  -235, -1000,  -239, -1000, -1000,   -93,
    -8, -1000, -1000, -1000,   -16, -1000,   -32,  -255,  -251, -1000,
 -1000,     7,    15, -1000, -1000,  -249, -1000,    -8, -1000, -1000,
  -270,  -240, -1000,    14,   -16, -1000, -1000, -1000, -1000,    -8,
 -1000,  -252, -1000,    13,   -16, -1000, -1000 };
yytabelem yypgo[]={

     0,    73,    53,    72,    50,    49,    35,    71,    34,    70,
    30,    67,    69,    37,    39,    68,    36,    43,    65,    66 };
yytabelem yyr1[]={

     0,    19,    19,     1,     2,     2,     3,     3,     4,     4,
     5,     5,     6,     6,     7,     7,     8,     8,     9,     9,
     9,    10,    10,    10,    10,    10,    10,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    11,    11,    12,
    12,    14,    14,    15,    15,    15,    13,    13,    16,    16,
    17,    17,    18,    18 };
yytabelem yyr2[]={

     0,     5,     3,     7,     3,     7,     9,     3,     1,     5,
     3,     3,     3,     7,     5,     3,     1,     5,     3,     3,
     9,     3,     3,     3,     3,     3,     3,     9,    11,    11,
    15,    11,    11,    13,    11,    11,     3,     3,     5,     3,
     3,     3,     7,    13,     9,     3,     1,     3,     1,     7,
     3,     7,     7,     3 };
yytabelem yychk[]={

 -1000,   -19,    -1,   -10,   257,   276,   277,   278,   279,   266,
   275,    40,   267,   259,   260,   263,   268,   269,   270,   272,
   256,   -10,    -2,    -3,   275,   256,   -10,    40,   -11,   -12,
   275,   256,   -10,   -10,    40,    40,   -18,   275,   256,   -17,
   -18,   258,    59,    -4,    -5,   273,   256,   -10,   -10,    46,
   -11,   261,   264,   274,   276,   271,    61,   271,    59,    -2,
    61,    -4,    41,   -10,   -10,   -10,   -14,   -15,    40,   274,
   256,   -16,    44,    44,   -10,   -10,   -10,   -17,    -6,    -7,
   274,   256,    41,   258,   262,   258,    59,   274,   -13,   -11,
    41,   -10,   -10,   258,   258,   124,    -8,    -9,   275,    -5,
    40,   -10,   -14,   -13,   265,   -16,    41,    -6,    -8,   275,
   258,    41,   -10,    -8,   265,    41,   -10 };
yytabelem yydef[]={

     0,    -2,     0,     2,     0,    21,    22,    23,    24,    25,
    26,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    36,     1,     0,     4,    -2,     7,     0,     0,     0,    -2,
    39,    40,     0,     0,     0,     0,     0,     0,    53,     0,
    50,     3,     0,     0,    -2,    10,    11,     0,     0,     0,
    38,     0,     0,    48,     0,     0,     0,     0,     0,     5,
     0,     9,    27,     0,     0,     0,     0,    41,     0,    -2,
    45,     0,     0,     0,     0,    52,     0,    51,     6,    12,
    -2,    15,    28,    29,     0,    31,     0,    -2,     0,    47,
    32,    48,     0,    34,    35,     0,    14,    -2,    18,    19,
     0,     0,    42,     0,     0,    49,    33,    13,    17,    -2,
    30,     0,    44,     0,     0,    20,    43 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"_TYPE",	257,
	"_END",	258,
	"_LAMBDA",	259,
	"_IF",	260,
	"_THEN",	261,
	"_ELSE",	262,
	"_CASE",	263,
	"_OF",	264,
	"_ARROW",	265,
	"_FAIL",	266,
	"_FATBAR",	267,
	"_CONSTRUCT",	268,
	"_SELECT",	269,
	"_LET",	270,
	"_IN",	271,
	"_LETREC",	272,
	"_SCHEMVAR",	273,
	"_CONSTRUCTOR",	274,
	"_IDENTIFIER",	275,
	"_INTEGER",	276,
	"_REAL",	277,
	"_CHAR",	278,
	"_STRING",	279,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"programm : typen ausdr",
	"programm : ausdr",
	"typen : _TYPE typdefs _END",
	"typdefs : def",
	"typdefs : def ';' typdefs",
	"def : _IDENTIFIER schemvars '=' sumtypen",
	"def : error",
	"schemvars : /* empty */",
	"schemvars : schemvar schemvars",
	"schemvar : _SCHEMVAR",
	"schemvar : error",
	"sumtypen : sum",
	"sumtypen : sum '|' sumtypen",
	"sum : _CONSTRUCTOR prodtypen",
	"sum : error",
	"prodtypen : /* empty */",
	"prodtypen : prod prodtypen",
	"prod : _IDENTIFIER",
	"prod : schemvar",
	"prod : '(' _IDENTIFIER prodtypen ')'",
	"ausdr : _INTEGER",
	"ausdr : _REAL",
	"ausdr : _CHAR",
	"ausdr : _STRING",
	"ausdr : _FAIL",
	"ausdr : _IDENTIFIER",
	"ausdr : '(' ausdr ausdr ')'",
	"ausdr : _FATBAR '(' ausdr ausdr ')'",
	"ausdr : _LAMBDA vars '.' ausdr _END",
	"ausdr : _IF ausdr _THEN ausdr _ELSE ausdr _END",
	"ausdr : _CASE ausdr _OF faelle _END",
	"ausdr : _CONSTRUCT '(' _CONSTRUCTOR ausdruecke ')'",
	"ausdr : _SELECT '(' _INTEGER ',' ausdr ')'",
	"ausdr : _LET vardef _IN ausdr _END",
	"ausdr : _LETREC vardefs _IN ausdr _END",
	"ausdr : error",
	"vars : var",
	"vars : var vars",
	"var : _IDENTIFIER",
	"var : error",
	"faelle : fall",
	"faelle : fall ';' faelle",
	"fall : '(' _CONSTRUCTOR varliste ')' _ARROW ausdr",
	"fall : _CONSTRUCTOR varliste _ARROW ausdr",
	"fall : error",
	"varliste : /* empty */",
	"varliste : vars",
	"ausdruecke : /* empty */",
	"ausdruecke : ',' ausdr ausdruecke",
	"vardefs : vardef",
	"vardefs : vardef ';' vardefs",
	"vardef : _IDENTIFIER '=' ausdr",
	"vardef : error",
};
#endif /* YYDEBUG */
/*
 *	@(#) yaccpar 1.4 88/11/11 
 *
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
#ident	"@(#)yacc:yaccpar	1.10"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
int yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 64 "el_syn.y"
{ defs = yypvt[-1].typzeiger; prog = yypvt[-0].auszeiger; } break;
case 2:
# line 66 "el_syn.y"
{ defs = NULL; prog = yypvt[-0].auszeiger; } break;
case 3:
# line 70 "el_syn.y"
{ yyval.typzeiger = defs = yypvt[-1].typzeiger; ueberpruefe(yypvt[-1].typzeiger); } break;
case 4:
# line 74 "el_syn.y"
{ yyval.typzeiger = yypvt[-0].typzeiger; } break;
case 5:
# line 76 "el_syn.y"
{ yyval.typzeiger = app_typ(yypvt[-2].typzeiger,yypvt[-0].typzeiger); } break;
case 6:
# line 80 "el_syn.y"
{ yyval.typzeiger = b_typ(yypvt[-3].val,yypvt[-2].prodzeiger,yypvt[-0].sumzeiger); } break;
case 7:
# line 82 "el_syn.y"
{ yyerror("Error in typ declaration"); } break;
case 8:
# line 85 "el_syn.y"
{ yyval.prodzeiger = NULL; } break;
case 9:
# line 87 "el_syn.y"
{ yyval.prodzeiger = app_prod(yypvt[-1].prodzeiger,yypvt[-0].prodzeiger); } break;
case 10:
# line 91 "el_syn.y"
{ yyval.prodzeiger = b_prod(yypvt[-0].val,NULL); } break;
case 11:
# line 93 "el_syn.y"
{ yyerror("Schemat. var. expected"); } break;
case 12:
# line 97 "el_syn.y"
{ yyval.sumzeiger = yypvt[-0].sumzeiger; } break;
case 13:
# line 99 "el_syn.y"
{ yyval.sumzeiger = app_sum(yypvt[-2].sumzeiger,yypvt[-0].sumzeiger); } break;
case 14:
# line 103 "el_syn.y"
{ yyval.sumzeiger = b_sum(yypvt[-1].val,yypvt[-0].prodzeiger); } break;
case 15:
# line 105 "el_syn.y"
{ yyerror("Constructor + args expected"); } break;
case 16:
# line 108 "el_syn.y"
{ yyval.prodzeiger = NULL; } break;
case 17:
# line 110 "el_syn.y"
{ yyval.prodzeiger = app_prod(yypvt[-1].prodzeiger,yypvt[-0].prodzeiger); } break;
case 18:
# line 113 "el_syn.y"
{ yyval.prodzeiger = b_prod(yypvt[-0].val,NULL); } break;
case 19:
# line 115 "el_syn.y"
{ yyval.prodzeiger = yypvt[-0].prodzeiger; } break;
case 20:
# line 117 "el_syn.y"
{ yyval.prodzeiger = b_prod(yypvt[-2].val,yypvt[-1].prodzeiger); } break;
case 21:
# line 122 "el_syn.y"
{ yyval.auszeiger = b_konst(KONST,INTEGER,yypvt[-0].val); } break;
case 22:
# line 124 "el_syn.y"
{ yyval.auszeiger = b_konst(KONST,REAL,yypvt[-0].val); } break;
case 23:
# line 126 "el_syn.y"
{ yyval.auszeiger = b_konst(KONST,CHAR,yypvt[-0].val); } break;
case 24:
# line 128 "el_syn.y"
{ yyval.auszeiger = b_string(yypvt[-0].val); } break;
case 25:
# line 130 "el_syn.y"
{ yyval.auszeiger = b_konst(FAIL,0,NULL); } break;
case 26:
# line 132 "el_syn.y"
{ yyval.auszeiger = b_konst(VAR,VARNAME,yypvt[-0].val); } break;
case 27:
# line 134 "el_syn.y"
{ yyval.auszeiger = b_anw(ANW,yypvt[-2].auszeiger,yypvt[-1].auszeiger); } break;
case 28:
# line 136 "el_syn.y"
{ yyval.auszeiger = b_anw(FATBAR,yypvt[-2].auszeiger,yypvt[-1].auszeiger); } break;
case 29:
# line 138 "el_syn.y"
{ yyval.auszeiger = b_lambda(yypvt[-3].defzeiger,yypvt[-1].auszeiger); } break;
case 30:
# line 140 "el_syn.y"
{ yyval.auszeiger = b_if(yypvt[-5].auszeiger,yypvt[-3].auszeiger,yypvt[-1].auszeiger); } break;
case 31:
# line 142 "el_syn.y"
{ yyval.auszeiger = b_case(yypvt[-3].auszeiger,yypvt[-1].auszeiger); } break;
case 32:
# line 144 "el_syn.y"
{ yyval.auszeiger = b_cons(yypvt[-2].val,yypvt[-1].auszeiger); } break;
case 33:
# line 146 "el_syn.y"
{ yyval.auszeiger = b_sel(yypvt[-3].val,yypvt[-1].auszeiger); } break;
case 34:
# line 148 "el_syn.y"
{ yyval.auszeiger = b_let(LET,yypvt[-3].defzeiger,yypvt[-1].auszeiger); } break;
case 35:
# line 150 "el_syn.y"
{ yyval.auszeiger = b_let(LETREC,yypvt[-3].defzeiger,yypvt[-1].auszeiger); } break;
case 36:
# line 152 "el_syn.y"
{ yyerror("Error in expression"); } break;
case 37:
# line 156 "el_syn.y"
{ yyval.defzeiger = yypvt[-0].defzeiger; } break;
case 38:
# line 158 "el_syn.y"
{ yyval.defzeiger = app_def(yypvt[-1].defzeiger,yypvt[-0].defzeiger); } break;
case 39:
# line 162 "el_syn.y"
{ yyval.defzeiger = b_def(yypvt[-0].val,NULL); } break;
case 40:
# line 164 "el_syn.y"
{ yyerror("Identifier expected"); } break;
case 41:
# line 168 "el_syn.y"
{ yyval.auszeiger = yypvt[-0].auszeiger; } break;
case 42:
# line 170 "el_syn.y"
{ yyval.auszeiger = app_ausl(yypvt[-2].auszeiger,yypvt[-0].auszeiger); } break;
case 43:
# line 174 "el_syn.y"
{ yyval.auszeiger = b_fall(yypvt[-4].val,yypvt[-3].defzeiger,yypvt[-0].auszeiger); } break;
case 44:
# line 176 "el_syn.y"
{ yyval.auszeiger = b_fall(yypvt[-3].val,yypvt[-2].defzeiger,yypvt[-0].auszeiger); } break;
case 45:
# line 178 "el_syn.y"
{ yyerror("Pattern => expr. expected"); } break;
case 46:
# line 181 "el_syn.y"
{ yyval.defzeiger = NULL; } break;
case 47:
# line 183 "el_syn.y"
{ yyval.defzeiger = yypvt[-0].defzeiger; } break;
case 48:
# line 186 "el_syn.y"
{ yyval.auszeiger = NULL; } break;
case 49:
# line 188 "el_syn.y"
{ yyval.auszeiger = app_ausl(yypvt[-1].auszeiger,yypvt[-0].auszeiger); } break;
case 50:
# line 192 "el_syn.y"
{ yyval.defzeiger = yypvt[-0].defzeiger; } break;
case 51:
# line 194 "el_syn.y"
{ yyval.defzeiger = app_def(yypvt[-2].defzeiger,yypvt[-0].defzeiger); } break;
case 52:
# line 198 "el_syn.y"
{ yyval.defzeiger = b_def(yypvt[-2].val,yypvt[-0].auszeiger); } break;
case 53:
# line 200 "el_syn.y"
{ yyerror("Identifier = expr. expected"); } break;
	}
	goto yystack;		/* reset registers in driver code */
}
