/* el_lex.l -- Lexikanalysator-Beschreibung fuer ELCOM */

idrest               [A-Za-z0-9_]*
real                 [0-9]+"."[0-9]+

%%

[ \t\n]              |
"%".*\n              ;
"type"               return _TYPE;
"end"                return _END;
"lambda"             return _LAMBDA;
"if"                 return _IF;
"then"               return _THEN;
"else"               return _ELSE;
"case"               return _CASE;
"of"                 return _OF;
"=>"                 return _ARROW;
"fail"               return _FAIL;
"fatbar"             return _FATBAR;
"construct"          return _CONSTRUCT;
"select"             return _SELECT;
"let"                return _LET;
"in"                 return _IN;
"letrec"             return _LETREC;
"*"{idrest}          { yylval.val = new(strlen(yytext)+1);
                       strcpy(yylval.val,yytext);
                       return _SCHEMVAR; }
[A-Z]{idrest}        { yylval.val = new(strlen(yytext)+1);
                       strcpy(yylval.val,yytext);
                       return _CONSTRUCTOR; }
[a-z_]{idrest}       { yylval.val = new(strlen(yytext)+1);
                       strcpy(yylval.val,yytext);
                       return _IDENTIFIER; }
[0-9]+               { yylval.val = new(strlen(yytext)+1);
                       strcpy(yylval.val,yytext);
                       return _INTEGER; }
{real}               |
{real}[Ee][0-9]+     { yylval.val = new(strlen(yytext)+1);
                       strcpy(yylval.val,yytext);
                       return _REAL; }
\'.\'                { yylval.val = new(strlen(yytext)+1);
                       strcpy(yylval.val,yytext);
                       return _CHAR; }
\"([^\"]|(\\\"))*\"  { yylval.val = new(strlen(yytext)+1);
                       strcpy(yylval.val,yytext);
                       return _STRING; }
.                    return *yytext;
