/* el_code.c -- Pass:  Codegenerator */

#include "elcom.h"

extern FILE *f;                           /* elcom.c    */
extern int  msg;                          /* elcom.c    */
extern int  sfunc[20];                    /* el_names.c */

extern struct typliste *defs;             /* elcom.c    */
extern struct ausdruck *prog;             /* elcom.c    */
extern struct comliste *comb;             /* elcom.c    */

extern struct hashtab *lookup (char *);   /* el_names.c */
extern int istkonst (char *);             /* el_names.c */
extern aus_defs (struct defliste *,
FILE *, int);                             /* el_print.c */

long labelnummer;

struct stack {
    struct stack *next;
    char         *var;
    char         *altvar;
    int          stackpos;
};

char *newlabel ()
{
    int  i;
    long l;
    char *c;

    i = 3;
    l = labelnummer;
    while ((l /= 10) > 0)
        i++;
    c = new(i);
    sprintf(c,"L%ld",labelnummer++);
    return c;
} /* newlabel */

struct stack *copystack (p)
struct stack *p;
{
    struct stack *s, *ss;

    s = NULL;
    while (p != NULL) {
        ss = (struct stack *) new(sizeof(struct stack));
        ss->var = p->var;
        ss->altvar = p->altvar;
        ss->stackpos = p->stackpos;
        ss->next = s;
        s = ss;
        p = p->next;
    }
    return s;
} /* copystack */

struct stack *append (p, name, altname, pos)
struct stack *p;
char         *name, *altname;
int          pos;
{
    struct stack *s;

    s = (struct stack *) new(sizeof(struct stack));
    s->var = name;
    s->altvar = altname;
    s->stackpos = pos;
    s->next = p;
    return s;
} /* append */

freestack (p)
struct stack *p;
{
    struct stack *s;

    while (p != NULL) {
        s = p;
        p = p->next;
        free(s);
    }
} /* freestack */

struct comliste *istkomb (c)
char *c;
{
    struct comliste *k;

    k = comb;
    while (k != NULL && strcmp(c,k->comname))
        k = k->next;
    return k;
} /* istkombinator */

int nchar (n)
int n;
{
    int i;

    i = 1;
    while ((n /= 10) > 0)
        i++;
    return i;
} /* nchar */

struct stack *pos (c, p)
char         *c;
struct stack *p;
{
    struct stack *s;

    s = p;
    while (s != NULL && strcmp(c,s->var))
        s = s->next;
    return s;
} /* pos */

int notevaled (ps, e)
int          ps;
struct stack *e;
{
    while (e != NULL && e->stackpos != ps)
        e = e->next;
    return e == NULL;
} /* notevaled */

struct stack *Xr (struct ausdruck *, struct stack *, int);
CLetrec (struct ausdruck *, struct stack *, int);
struct stack *E (struct ausdruck *, struct stack *, int,
struct stack *);
struct stack *RS (struct ausdruck *, struct stack *, int,
int, struct stack *);
struct stack *CS (struct ausdruck *, struct stack *, int,
int, struct stack *);
struct stack *ES (struct ausdruck *, struct stack *, int,
int, struct stack *);
B (struct ausdruck *, struct stack *, int, struct stack *);

struct stack *C (a, p, d, e)
struct ausdruck *a;
struct stack    *p;
int             d;
struct stack    *e;
{
    struct ausdruck *aa, *al;
    struct comliste *k;
    struct stack    *lab, *pp, *s, *ss;
    int             dd, i, j, st;
    char            *c, *cc;

    /* Generiert Code zur Konstruktion  des  Gra- */
    /* phen von "a".                              */
    switch(a->art) {
    case KONST:
        switch (a->standardtyp) {
        case INTEGER:
            c = "INT ";
            break;
        case REAL:
            c = "REAL";
            break;
        case CHAR:
            c = "CHAR";
        }
        fprintf(f,"    PUSH%s  %s \n",c,a->wert);
        return e;
    case VAR:
        if ((k = istkomb(a->wert)) != NULL) {
            i = strlen(k->comname) + nchar(k->anzargs);
            fprintf(f,"    PUSHFUN   %s, %d ",
                k->comname,k->anzargs);
            for (j = 17 + i; j++ < 28; )
                putc(' ',f);
            fprintf(f,"%% %s \n",k->altcom);
            return e;
        }
        if (!strcmp(a->wert,"neg") ||
            !strcmp(a->wert,"not") ||
            !strcmp(a->wert,"ord") ||
            !strcmp(a->wert,"chr") ||
            !strcmp(a->wert,"seq") ||
            !strcmp(a->wert,"read")) {
            fprintf(f,"    PUSHFUN   %s, 1 \n",a->wert);
            return e;
        }
        if (istkonst(a->wert)) {
            fprintf(f,"    PUSHFUN   %s, 2 \n",a->wert);
            return e;
        }
        s = pos(a->wert,p);
        if (s == NULL) {
            puts("! Internal error 1");
            exit(4);
        }
        i = nchar(d - s->stackpos);
        fprintf(f,"    PUSH      %d ",d - s->stackpos);
        for (j = 15 + i; j++ < 28; )
            putc(' ',f);
        fprintf(f,"%% %s \n",s->altvar);
        return e;
    case FAIL:
        fputs("    PUSHFAIL \n",f);
        return e;
    case FATBAR:
        e = E(a->links,p,d,e);
        c = newlabel();
        cc = newlabel();
        fprintf(f,"    JFAIL     %s \n",c);
        fprintf(f,"    JUMP      %s \n",cc);
        fprintf(f,"%s: \n",c);
        e = C(a->rechts,p,d,e);
        fprintf(f,"%s: \n",cc);
        free(c);
        free(cc);
        return e;
    case ANW:
        e = CS(a,p,d,0,e);
        return e;
    case IF:
        B(a->links,p,d,e);
        c = newlabel();
        cc = newlabel();
        fprintf(f,"    JFALSE    %s \n",c);
        e = C(a->rechts,p,d,e);
        fprintf(f,"    JUMP      %s \n",cc);
        fprintf(f,"%s: \n",c);
        e = C(a->rechts->hinten,p,d,e);
        fprintf(f,"%s: \n",cc);
        free(c);
        free(cc);
        return e;
    case CASE:
        e = E(a->links,p,d,e);
        fputs("    CASEJUMP  ",f);
        aa = a->rechts;
        lab = NULL;
        while (aa != NULL) {
            /* Markenliste fuer CASEJUMP erzeugen */
            s = (struct stack *) new(sizeof(struct stack));
            s->var = newlabel();
            s->next = NULL;
            fprintf(f,"(%d,%s), ",aa->standardtyp,s->var);
            if (lab == NULL)
                lab = s;
            else {
                ss = lab;
                while (ss->next != NULL)
                    ss = ss->next;
                ss->next = s;
            }
            aa = aa->hinten;
        }
        c = newlabel();
        cc = newlabel();
        fprintf(f,"%s \n",c);
        aa = a->rechts;
        s = lab;
        while (aa != NULL) {
            /* Uebersetzen der CASE-Faelle */
            fprintf(f,"%s: \n",s->var);
            pp = Xr(aa,p,d);
            dd = d + aa->stelligkeit;
            e = C(aa->links,pp,dd,e);
            if (aa->stelligkeit != 0)
                fprintf(f,"    SLIDE     %d \n",
                    aa->stelligkeit);
            fprintf(f,"    JUMP      %s \n",cc);
            freestack(pp);
            s = s->next;
            aa = aa->hinten;
        }
        /* Default: */
        fprintf(f,"%s: \n",c);
        fprintf(f,"    PUSHFAIL \n");
        /* Marke nach CASE: */
        fprintf(f,"%s: \n",cc);
        free(c);
        free(cc);
        freestack(lab);
        return e;
    case CONS:
        if ((al = a->links) != NULL) {
            st = 1;
            while (al->hinten != NULL) {
                st++;
                al = al->hinten;
            }
            for (;;) {
                e = C(al,p,d++,e);
                if (al == a->links)
                    break;
                aa = a->links;
                while (aa->hinten != al)
                    aa = aa->hinten;
                al = aa;
            }
        }
        i = nchar(a->standardtyp) + nchar(st);
        fprintf(f,"    CONS      %d, %d ",
            a->standardtyp,st);
        for (j = 17 + i; j++ < 28; )
            putc(' ',f);
        fprintf(f,"%% %s \n",a->wert);
        return e;
    case SELECT:
        e = E(a->links,p,d,e);
        fprintf(f,"    SELECT    %s \n",a->wert);
        return e;
    case LET:
        if (a->definition->defstrikt)
            e = E(a->definition->varwert,p,d,e);
        else
            e = C(a->definition->varwert,p,d,e);
        pp = copystack(p);
        pp = append(p,a->definition->varname,
            a->definition->sym->altname,++d);
        e = C(a->links,p,d,e);
        freestack(pp);
        fprintf(f,"    SLIDE     1 \n");
        return e;
    case LETREC:
        pp = Xr(a,p,d);
        dd = d + a->stelligkeit;
        CLetrec(a,pp,dd);
        e = C(a->links,p,d,e);
        freestack(pp);
        fprintf(f,"    SLIDE     %d \n",dd-d);
        return e;
    }
} /* C */

struct stack *Xr (a, p, d)
struct ausdruck *a;
struct stack    *p;
int             d;
{
    struct defliste *df;
    struct stack    *s;

    df = a->definition;
    s = NULL;
    s = copystack(p);
    while (df != NULL) {
        s = append(s,df->varname,df->sym->altname,++d);
        df = df->next;
    }
    return s;
} /* Xr */

CLetrec (a, p, d)
struct ausdruck *a;
struct stack    *p;
int             d;
{
    struct defliste *df;
    struct stack    *e;
    int             n;

    n = a->stelligkeit;
    df = a->definition;
    fprintf(f,"    ALLOC     %d \n",n);
    while (df != NULL) {
        e = C(df->varwert,p,d,NULL);
        freestack(e);
        fprintf(f,"    UPDATE    %d \n",n--);
        df = df->next;
    }
} /* CLetrec */

struct stack *E (a, p, d, e)
struct ausdruck *a;
struct stack    *p;
int             d;
struct stack    *e;
{
    struct ausdruck *aa, *al;
    struct comliste *k;
    struct stack    *lab, *pp, *s, *ss;
    int             dd, i, j, st;
    char            *c, *cc;

    /* Generiert Code zur Auswertung von "a". Das */
    /* Ergebnis ist an der Stack-Spitze.          */
    switch(a->art) {
    case KONST:
        switch (a->standardtyp) {
        case INTEGER:
            c = "INT ";
            break;
        case REAL:
            c = "REAL";
            break;
        case CHAR:
            c = "CHAR";
        }
        fprintf(f,"    PUSH%s  %s \n",c,a->wert);
        return e;
    case VAR:
        if ((k = istkomb(a->wert)) != NULL) {
            i = strlen(k->comname) + nchar(k->anzargs);
            fprintf(f,"    PUSHFUN   %s, %d ",
                k->comname,k->anzargs);
            for (j = 17 + i; j++ < 28; )
                putc(' ',f);
            fprintf(f,"%% %s \n",k->altcom);
            return e;
        }
        if (!strcmp(a->wert,"neg") ||
            !strcmp(a->wert,"not") ||
            !strcmp(a->wert,"ord") ||
            !strcmp(a->wert,"chr") ||
            !strcmp(a->wert,"seq") ||
            !strcmp(a->wert,"read")) {
            fprintf(f,"    PUSHFUN   %s, 1 \n",a->wert);
            return e;
        }
        if (istkonst(a->wert)) {
            fprintf(f,"    PUSHFUN   %s, 2 \n",a->wert);
            return e;
        }
        s = pos(a->wert,p);
        if (s == NULL) {
            puts("! Internal error 2");
            exit(4);
        }
        i = nchar(d - s->stackpos);
        fprintf(f,"    PUSH      %d ",d - s->stackpos);
        for (j = 15 + i; j++ < 28; )
            putc(' ',f);
        fprintf(f,"%% %s \n",s->altvar);
        if (notevaled(s->stackpos,e))
            fprintf(f,"    EVAL       \n");
        return e;
    case FAIL:
        fputs("    PUSHFAIL \n",f);
        return e;
    case FATBAR:
        e = E(a->links,p,d,e);
        c = newlabel();
        cc = newlabel();
        fprintf(f,"    JFAIL     %s \n",c);
        fprintf(f,"    JUMP      %s \n",cc);
        fprintf(f,"%s: \n",c);
        e = E(a->rechts,p,d,e);
        fprintf(f,"%s: \n",cc);
        free(c);
        free(cc);
        return e;
    case ANW:
        aa = a;
        i = 0;
        while (aa->art == ANW) {
            i++;
            aa = aa->links;
        }
        if (istkonst(aa->wert)) {
            if ((!strcmp(aa->wert,"neg") ||
                !strcmp(aa->wert,"not") ||
                !strcmp(aa->wert,"ord") ||
                !strcmp(aa->wert,"chr")) && i == 1)
                j = 1;
            else if (i == 2 && strcmp(aa->wert,"seq") &&
                strcmp(aa->wert,"ord") &&
                strcmp(aa->wert,"chr") &&
                strcmp(aa->wert,"neg") &&
                strcmp(aa->wert,"not") &&
                strcmp(aa->wert,"read"))
                j = 1;
            else
                j = 0;
            if (j) {
                B(a,p,d,e);
                fputs("    MKBASIC \n",f);
                return e;
            }
        }
        e = ES(a,p,d,0,e);
        return e;
    case IF:
        B(a->links,p,d,e);
        c = newlabel();
        cc = newlabel();
        fprintf(f,"    JFALSE    %s \n",c);
        e = E(a->rechts,p,d,e);
        fprintf(f,"    JUMP      %s \n",cc);
        fprintf(f,"%s: \n",c);
        e = E(a->rechts->hinten,p,d,e);
        fprintf(f,"%s: \n",cc);
        free(c);
        free(cc);
        return e;
    case CASE:
        e = E(a->links,p,d,e);
        fputs("    CASEJUMP  ",f);
        aa = a->rechts;
        lab = NULL;
        while (aa != NULL) {
            /* Markenliste fuer CASEJUMP erzeugen */
            s = (struct stack *) new(sizeof(struct stack));
            s->var = newlabel();
            s->next = NULL;
            fprintf(f,"(%d,%s), ",aa->standardtyp,s->var);
            if (lab == NULL)
                lab = s;
            else {
                ss = lab;
                while (ss->next != NULL)
                    ss = ss->next;
                ss->next = s;
            }
            aa = aa->hinten;
        }
        c = newlabel();
        cc = newlabel();
        fprintf(f,"%s \n",c);
        aa = a->rechts;
        s = lab;
        while (aa != NULL) {
            /* Uebersetzen der CASE-Faelle */
            fprintf(f,"%s: \n",s->var);
            pp = Xr(aa,p,d);
            dd = d + aa->stelligkeit;
            e = E(aa->links,pp,dd,e);
            if (aa->stelligkeit != 0)
                fprintf(f,"    SLIDE     %d \n",
                    aa->stelligkeit);
            fprintf(f,"    JUMP      %s \n",cc);
            freestack(pp);
            s = s->next;
            aa = aa->hinten;
        }
        /* Default: */
        fprintf(f,"%s: \n",c);
        fprintf(f,"    PUSHFAIL \n");
        /* Marke nach CASE: */
        fprintf(f,"%s: \n",cc);
        free(c);
        free(cc);
        freestack(lab);
        return e;
    case CONS:
        if ((al = a->links) != NULL) {
            st = 1;
            while (al->hinten != NULL) {
                st++;
                al = al->hinten;
            }
            for (;;) {
                e = C(al,p,d++,e);
                if (al == a->links)
                    break;
                aa = a->links;
                while (aa->hinten != al)
                    aa = aa->hinten;
                al = aa;
            }
        }
        i = nchar(a->standardtyp) + nchar(st);
        fprintf(f,"    CONS      %d, %d ",
            a->standardtyp,st);
        for (j = 17 + i; j++ < 28; )
            putc(' ',f);
        fprintf(f,"%% %s \n",a->wert);
        return e;
    case SELECT:
        e = E(a->links,p,d,e);
        fprintf(f,"    SELECT    %s \n",a->wert);
        fprintf(f,"    EVAL         \n");
        return e;
    case LET:
        if (a->definition->defstrikt)
            e = E(a->definition->varwert,p,d,e);
        else
            e = C(a->definition->varwert,p,d,e);
        pp = copystack(p);
        pp = append(p,a->definition->varname,
            a->definition->sym->altname,++d);
        e = E(a->links,p,d,e);
        freestack(pp);
        fprintf(f,"    SLIDE     1 \n");
        return e;
    case LETREC:
        pp = Xr(a,p,d);
        dd = d + a->stelligkeit;
        CLetrec(a,pp,dd);
        e = E(a->links,p,d,e);
        freestack(pp);
        fprintf(f,"    SLIDE     %d \n",dd-d);
        return e;
    }
} /* E */

struct stack *RS (a, p, d, n, e)
struct ausdruck *a;
struct stack    *p;
int             d, n;
struct stack    *e;
{
    struct comliste *k;
    struct stack    *s;
    int             i, j;

    switch (a->art) {
    case VAR:
        if ((k = istkomb(a->wert)) != NULL) {
            i = strlen(k->comname) + nchar(k->anzargs);
            fprintf(f,"    PUSHFUN   %s, %d ",
                k->comname,k->anzargs);
            for (j = 17 + i; j++ < 28; )
                putc(' ',f);
            fprintf(f,"%% %s \n",k->altcom);
        }
        else if (!strcmp(a->wert,"neg") ||
            !strcmp(a->wert,"not") ||
            !strcmp(a->wert,"ord") ||
            !strcmp(a->wert,"chr") ||
            !strcmp(a->wert,"seq") ||
            !strcmp(a->wert,"read")) {
            fprintf(f,"    PUSHFUN   %s, 1 \n",a->wert);
        }
        else if (istkonst(a->wert)) {
            fprintf(f,"    PUSHFUN   %s, 2 \n",a->wert);
        }
        else {
            s = pos(a->wert,p);
            if (s == NULL) {
                puts("! Internal error 3");
                exit(4);
            }
            i = nchar(d - s->stackpos);
            fprintf(f,"    PUSH      %d ",d - s->stackpos);
            for (j = 15 + i; j++ < 28; )
                putc(' ',f);
            fprintf(f,"%% %s \n",s->altvar);
            if (notevaled(s->stackpos,e))
                fputs("    EVAL \n",f);
        }
        fprintf(f,"    MKAP      %d \n",n);
        fprintf(f,"    UPDATE    %d \n",d-n+1);
        if (d-n != 0)
            fprintf(f,"    POP       %d \n",d-n);
        fprintf(f,"    UNWIND       \n");
        return e;
    case ANW:
        if (a->strikt)
            e = E(a->rechts,p,d,e);
        else
            e = C(a->rechts,p,d,e);
        e = RS(a->links,p,d+1,n+1,e);
        return e;
    }
} /* RS */

struct stack *CS (a, p, d, n, e)
struct ausdruck *a;
struct stack    *p;
int             d, n;
struct stack    *e;
{
    struct comliste *k;
    struct stack    *s;
    int             i, j;

    switch (a->art) {
    case VAR:
        if ((k = istkomb(a->wert)) != NULL) {
            i = strlen(k->comname) + nchar(k->anzargs);
            fprintf(f,"    PUSHFUN   %s, %d ",
                k->comname,k->anzargs);
            for (j = 17 + i; j++ < 28; )
                putc(' ',f);
            fprintf(f,"%% %s \n",k->altcom);
        }
        else if (!strcmp(a->wert,"neg") ||
            !strcmp(a->wert,"not") ||
            !strcmp(a->wert,"ord") ||
            !strcmp(a->wert,"chr") ||
            !strcmp(a->wert,"seq") ||
            !strcmp(a->wert,"read")) {
            fprintf(f,"    PUSHFUN   %s, 1 \n",a->wert);
        }
        else if (istkonst(a->wert)) {
            fprintf(f,"    PUSHFUN   %s, 2 \n",a->wert);
        }
        else {
            s = pos(a->wert,p);
            if (s == NULL) {
                puts("! Internal error 4");
                exit(4);
            }
            i = nchar(d - s->stackpos);
            fprintf(f,"    PUSH      %d ",d - s->stackpos);
            for (j = 15 + i; j++ < 28; )
                putc(' ',f);
            fprintf(f,"%% %s \n",s->altvar);
            if (notevaled(s->stackpos,e))
                fputs("    EVAL \n",f);
        }
        fprintf(f,"    MKAP      %d \n",n);
        return e;
    case ANW:
        if (a->strikt)
            e = E(a->rechts,p,d,e);
        else
            e = C(a->rechts,p,d,e);
        e = CS(a->links,p,d+1,n+1,e);
        return e;
    }
} /* CS */

struct stack *ES (a, p, d, n, e)
struct ausdruck *a;
struct stack    *p;
int             d, n;
struct stack    *e;
{
    struct comliste *k;
    struct stack    *s;
    int             i, j;

    switch (a->art) {
    case VAR:
        if ((k = istkomb(a->wert)) != NULL) {
            i = strlen(k->comname) + nchar(k->anzargs);
            fprintf(f,"    PUSHFUN   %s, %d ",
                k->comname,k->anzargs);
            for (j = 17 + i; j++ < 28; )
                putc(' ',f);
            fprintf(f,"%% %s \n",k->altcom);
        }
        else if (!strcmp(a->wert,"neg") ||
            !strcmp(a->wert,"not") ||
            !strcmp(a->wert,"ord") ||
            !strcmp(a->wert,"chr") ||
            !strcmp(a->wert,"seq") ||
            !strcmp(a->wert,"read")) {
            fprintf(f,"    PUSHFUN   %s, 1 \n",a->wert);
        }
        else if (istkonst(a->wert)) {
            fprintf(f,"    PUSHFUN   %s, 2 \n",a->wert);
        }
        else {
            s = pos(a->wert,p);
            if (s == NULL) {
                puts("! Internal error 5");
                exit(4);
            }
            i = nchar(d - s->stackpos);
            fprintf(f,"    PUSH      %d ",d - s->stackpos);
            for (j = 15 + i; j++ < 28; )
                putc(' ',f);
            fprintf(f,"%% %s \n",s->altvar);
            if (notevaled(s->stackpos,e))
                fputs("    EVAL \n",f);
        }
        fprintf(f,"    MKAP      %d \n",n);
        fprintf(f,"    EVAL         \n");
        return e;
    case ANW:
        if (a->strikt)
            e = E(a->rechts,p,d,e);
        else
            e = C(a->rechts,p,d,e);
        e = ES(a->links,p,d+1,n+1,e);
        return e;
    }
} /* ES */

char *upper (c)
char *c;
{
    int  i;
    char *cc;

    i = 0;
    cc = new(strlen(c)+1);
    while (c[i] != '\0') {
        cc[i] = (char)((int)(c[i]) - 32);
        i++;
    }
    cc[i] = '\0';
    return cc;
} /* upper */

B (a, p, d, e)
struct ausdruck *a;
struct stack    *p;
int             d;
struct stack    *e;
{
    struct ausdruck *aa;
    struct stack    *lab, *pp, *s, *ss;
    int             dd, i;
    char            *c, *cc;

    /* Generiert Code zur Ausfuehrung des  Basis- */
    /* wert-Rechnungen.                           */
    switch (a->art) {
    case KONST:
        fprintf(f,"    PUSHBASIC %s \n",a->wert);
        return;
    case ANW:
        aa = a;
        i = 0;
        while (aa->art == ANW) {
            i++;
            aa = aa->links;
        }
        if ((!strcmp(aa->wert,"neg") ||
            !strcmp(aa->wert,"not") ||
            !strcmp(aa->wert,"ord") ||
            !strcmp(aa->wert,"chr")) && i == 1) {
            B(a->rechts,p,d,e);
            c = upper(aa->wert);
            fprintf(f,"    %s \n",c);
            free(c);
            return;
        }
        else if (istkonst(aa->wert) && i == 2) {
            B(a->rechts,p,d,e);
            B(a->links->rechts,p,d,e);
            c = upper(aa->wert);
            fprintf(f,"    %s \n",c);
            free(c);
            return;
        }
        e = E(a,p,d,e);
        fputs("    GET \n",f);
        return;
    case FATBAR:
        e = E(a->links,p,d,e);
        c = newlabel();
        cc = newlabel();
        fprintf(f,"    JFAIL     %s \n",c);
        fprintf(f,"    GET          \n");
        fprintf(f,"    JUMP      %s \n",cc);
        fprintf(f,"%s: \n",c);
        B(a->rechts,p,d,e);
        fprintf(f,"%s: \n",cc);
        free(c);
        free(cc);
        return;
    case IF:
        B(a->links,p,d,e);
        c = newlabel();
        cc = newlabel();
        fprintf(f,"    JFALSE    %s \n",c);
        B(a->rechts,p,d,e);
        fprintf(f,"    JUMP      %s \n",cc);
        fprintf(f,"%s: \n",c);
        B(a->rechts->hinten,p,d,e);
        fprintf(f,"%s: \n",cc);
        free(c);
        free(cc);
        return;
    case CASE:
        e = E(a->links,p,d,e);
        fputs("    CASEJUMP  ",f);
        aa = a->rechts;
        lab = NULL;
        while (aa != NULL) {
            /* Markenliste fuer CASEJUMP erzeugen */
            s = (struct stack *) new(sizeof(struct stack));
            s->var = newlabel();
            s->next = NULL;
            fprintf(f,"(%d,%s), ",aa->standardtyp,s->var);
            if (lab == NULL)
                lab = s;
            else {
                ss = lab;
                while (ss->next != NULL)
                    ss = ss->next;
                ss->next = s;
            }
            aa = aa->hinten;
        }
        c = newlabel();
        cc = newlabel();
        fprintf(f,"%s \n",c);
        aa = a->rechts;
        s = lab;
        while (aa != NULL) {
            /* Uebersetzen der CASE-Faelle */
            fprintf(f,"%s: \n",s->var);
            pp = Xr(aa,p,d);
            dd = d + aa->stelligkeit;
            B(aa->links,pp,dd,e);
            if (aa->stelligkeit != 0)
                fprintf(f,"    POP       %d \n",
                    aa->stelligkeit);
            fprintf(f,"    JUMP      %s \n",cc);
            freestack(pp);
            s = s->next;
            aa = aa->hinten;
        }
        /* Default -- Fehler: */
        fprintf(f,"%s: \n    END \n",c);
        /* Marke nach CASE: */
        fprintf(f,"%s: \n",cc);
        free(c);
        free(cc);
        freestack(lab);
        return;
    case LET:
        if (a->definition->defstrikt)
            e = E(a->definition->varwert,p,d,e);
        else
            e = C(a->definition->varwert,p,d,e);
        pp = copystack(p);
        pp = append(p,a->definition->varname,
            a->definition->sym->altname,++d);
        B(a->links,p,d,e);
        freestack(pp);
        fprintf(f,"    POP       1 \n");
        return;
    case LETREC:
        pp = Xr(a,p,d);
        dd = d + a->stelligkeit;
        CLetrec(a,pp,dd);
        B(a->links,p,d,e);
        freestack(pp);
        fprintf(f,"    POP       %d \n",dd-d);
        return;
    default:
        e = E(a,p,d,e);
        fputs("    GET \n",f);
    }
} /* B */

struct stack *R (a, p, d, e)
struct ausdruck *a;
struct stack    *p;
int             d;
struct stack    *e;
{
    struct ausdruck *aa;
    struct comliste *k;
    struct defliste *df;
    struct stack    *lab, *pp, *s, *ss;
    int             dd, i, j;
    char            *c;

    /* Generiert Code zur Anwendung eines  Super- */
    /* kombinators auf seine d Argumente.         */
    switch (a->art) {
    case KONST:
        B(a,p,d,e);
        fprintf(f,"    UPDBASIC  %d \n",d);
        if (d != 0)
            fprintf(f,"    POP       %d \n",d);
        fprintf(f,"    RETURN       \n");
        return e;
    case VAR:
    case CONS:
    case SELECT:
        e = E(a,p,d,e);
        fprintf(f,"    UPDATE    %d \n",d+1);
        if (d != 0)
            fprintf(f,"    POP       %d \n",d);
        fprintf(f,"    UNWIND       \n");
        return e;
    case FAIL:
        fprintf(f,"    PUSHFAIL     \n");
        fprintf(f,"    UPDATE    %d \n",d+1);
        if (d != 0)
            fprintf(f,"    POP       %d \n",d);
        fprintf(f,"    RETURN       \n");
        return e;
    case FATBAR:
        e = E(a->links,p,d,e);
        c = newlabel();
        fprintf(f,"    JFAIL     %s \n",c);
        fprintf(f,"    UPDATE    %d \n",d+1);
        if (d != 0)
            fprintf(f,"    POP       %d \n",d);
        fprintf(f,"    UNWIND       \n");
        fprintf(f,"%s: \n",c);
        free(c);
        e = R(a->rechts,p,d,e);
        return e;
    case ANW:
        aa = a;
        i = 0;
        while (aa->art == ANW) {
            i++;
            aa = aa->links;
        }
        if (istkonst(aa->wert)) {
            if ((!strcmp(aa->wert,"neg") ||
                !strcmp(aa->wert,"not") ||
                !strcmp(aa->wert,"ord") ||
                !strcmp(aa->wert,"chr")) && i == 1)
                j = 1;
            else if (i == 2 && strcmp(aa->wert,"seq") &&
                strcmp(aa->wert,"neg") &&
                strcmp(aa->wert,"not") &&
                strcmp(aa->wert,"ord") &&
                strcmp(aa->wert,"chr") &&
                strcmp(aa->wert,"read"))
                j = 1;
            else
                j = 0;
            if (j) {
                B(a,p,d,e);
                fprintf(f,"    UPDBASIC  %d \n",d);
                if (d != 0)
                    fprintf(f,"    POP       %d \n",d);
                fprintf(f,"    RETURN       \n");
                return e;
            }
        }
        if ((k = istkomb(aa->wert)) != NULL &&
            k->anzargs == i) {
            /* Tail Call */
            dd = d;
            aa = a;
            while (aa->art == ANW) {
                e = C(aa->rechts,p,dd++,e);
                aa = aa->links;
            }
            if (d != 0)
                fprintf(f,"    SQUEEZE   %d, %d \n",
                    i,d);
            fprintf(f,"    JUMP      %s ",aa->wert);
            for (j = 15 + strlen(aa->wert); j++ < 28; )
                putc(' ',f);
            fprintf(f,"%% %s (combinator) \n",k->altcom);
            return e;
        }
        e = RS(a,p,d,0,e);
        return e;
    case IF:
        B(a->links,p,d,e);
        c = newlabel();
        fprintf(f,"    JFALSE    %s \n",c);
        e = R(a->rechts,p,d,e);
        fprintf(f,"%s: \n",c);
        free(c);
        e = R(a->rechts->hinten,p,d,e);
        return e;
    case CASE:
        e = E(a->links,p,d,e);
        fputs("    CASEJUMP  ",f);
        aa = a->rechts;
        lab = NULL;
        while (aa != NULL) {
            /* Markenliste fuer CASEJUMP erzeugen */
            s = (struct stack *) new(sizeof(struct stack));
            s->var = newlabel();
            s->next = NULL;
            fprintf(f,"(%d,%s), ",aa->standardtyp,s->var);
            if (lab == NULL)
                lab = s;
            else {
                ss = lab;
                while (ss->next != NULL)
                    ss = ss->next;
                ss->next = s;
            }
            aa = aa->hinten;
        }
        c = newlabel();
        fprintf(f,"%s \n",c);
        aa = a->rechts;
        s = lab;
        while (aa != NULL) {
            /* Uebersetzen der CASE-Faelle */
            fprintf(f,"%s: \n",s->var);
            pp = Xr(aa,p,d);
            dd = d + aa->stelligkeit;
            e = R(aa->links,pp,dd,e);
            freestack(pp);
            s = s->next;
            aa = aa->hinten;
        }
        /* Default: */
        fprintf(f,"%s: \n",c);
        fprintf(f,"    PUSHFAIL \n");
        fprintf(f,"    UPDATE    %d \n",d+1);
        if (d != 0)
            fprintf(f,"    POP       %d \n",d);
        fprintf(f,"    RETURN       \n");
        freestack(lab);
        free(c);
        return e;
    case LET:
        df = a->definition;
        if (df->defstrikt)
            e = E(df->varwert,p,d,e);
        else
            e = C(df->varwert,p,d,e);
        pp = copystack(p);
        pp = append(pp,df->varname,df->sym->altname,++d);
        e = R(a->links,pp,d,e);
        freestack(pp);
        return e;
    case LETREC:
        pp = Xr(a,p,d);
        d += a->stelligkeit;
        CLetrec(a,pp,d);
        e = R(a->links,pp,d,e);
        freestack(pp);
        return e;
    }
} /* R */

standard1 (fun)
char *fun;
{
    char *c;

    fprintf(f,"%s: \n",fun);
    fputs("    EVAL \n",f);
    fputs("    GET  \n",f);
    c = upper(fun);
    fprintf(f,"    %s \n",c);
    fputs("    UPDBASIC  0 \n",f);
    fputs("    RETURN    \n\n",f);
    free(c);
} /* standard1 */

standard2 (fun)
char *fun;
{
    char *c;

    fprintf(f,"%s: \n",fun);
    fputs("    PUSH      1 \n",f);
    fputs("    EVAL \n",f);
    fputs("    GET  \n",f);
    fputs("    EVAL \n",f);
    fputs("    GET  \n",f);
    c = upper(fun);
    fprintf(f,"    %s \n",c);
    fputs("    UPDBASIC  1 \n",f);
    fputs("    POP       1 \n",f);
    fputs("    RETURN    \n\n",f);
    free(c);
} /* standard2 */

codegen (name)
char *name;
{
    struct comliste *k;
    struct defliste *df;
    struct stack    *e, *sb, *s;
    int             i;

    labelnummer = 1;
    /* Vorspann: */
    fprintf(f,"%% Program \"%s\" \n\n",name);
    fprintf(f,"    BEGIN     Main \n");
    fprintf(f,"    EVAL  \n");
    fprintf(f,"    PRINT \n");
    fprintf(f,"    END   \n\n");
    fprintf(f,"Main: \n");
    fprintf(f,"%% Main expression to be evaluated. \n");
    if (msg == 2)
        puts("Generating code for main expression");
    e = R(prog,NULL,0,NULL);
    freestack(e);
    k = comb;
    while (k != NULL) {
        if (msg == 2)
            printf("Generating code for combinator \"%s\"\n",
                k->altcom);
        fprintf(f,"\n%s: \n",k->comname),
            fprintf(f,"%% Combinator (%d arg",k->anzargs);
        if (k->anzargs != 1)
            putc('s',f);
        fprintf(f,"). Original: \"%s\" (%d arg",
            k->altcom,k->altanz);
        if (k->altanz != 1)
            putc('s',f);
        fputs("). \n% Argument",f);
        if (k->anzargs != 1)
            putc('s',f);
        putc(':',f);
        aus_defs(k->args,f,0);
        putc('\n',f);
        i = k->anzargs;
        e = NULL;
        sb = NULL;
        df = k->args;
        while (df != NULL) {
            s = (struct stack *) new(sizeof(struct stack));
            s->var = df->varname;
            s->altvar = df->sym->altname;
            s->stackpos = i;
            s->next = sb;
            sb = s;
            if (df->defstrikt) {
                if (i == k->anzargs)
                    fprintf(f,"    EVAL         \n");
                else {
                    fprintf(f,"    PUSH      %d \n",
                        k->anzargs - i);
                    fprintf(f,"    EVAL         \n");
                    fprintf(f,"    POP       1  \n");
                }
                e = append(e,NULL,NULL,i);
            }
            i--;
            df = df->next;
        }
        e = R(k->koerper,sb,k->anzargs,e);
        freestack(e);
        freestack(sb);
        k = k->next;
    }
    fputs("\n% Built-in combinators \n\n",f);
    if (sfunc[0])
        standard1("not");
    if (sfunc[1])
        standard1("neg");
    if (sfunc[2])
        standard2("add");
    if (sfunc[3])
        standard2("sub");
    if (sfunc[4])
        standard2("mult");
    if (sfunc[5])
        standard2("div");
    if (sfunc[6])
        standard2("mod");
    if (sfunc[7])
        standard2("and");
    if (sfunc[8])
        standard2("or");
    if (sfunc[9])
        standard2("lt");
    if (sfunc[10])
        standard2("leq");
    if (sfunc[11])
        standard2("eq");
    if (sfunc[12])
        standard2("neq");
    if (sfunc[13])
        standard2("geq");
    if (sfunc[14])
        standard2("gt");
    if (sfunc[15])
        standard1("ord");
    if (sfunc[16])
        standard1("chr");
    if (sfunc[17]) {
        fputs("seq: \n",f);
        fputs("    EVAL        \n",f);
        fputs("    POP       1 \n",f);
        fputs("    EVAL        \n",f);
        fputs("    UPDATE    1 \n",f);
        fputs("    UNWIND    \n\n",f);
    }
    if (sfunc[18]) {
        fputs("read: \n",f);
        fputs("    PUSH      0 \n",f);
        fputs("    EVAL        \n",f);
        fputs("    PUSHFUN   Revalarg, 1 \n",f);
        fputs("    MKAP        \n",f);
        fputs("    EVAL        \n",f);
        fputs("    OPEN        \n",f);
        fputs("    PUSHFUN   Rread, 1 \n",f);
        fputs("    MKAP        \n",f);
        fputs("    EVAL        \n",f);
        fputs("    UPDATE    2 \n",f);
        fputs("    POP       1 \n",f);
        fputs("    RETURN    \n\n",f);
        fputs("Revalarg: \n",f);
        fputs("    PUSH      0 \n",f);
        fputs("    CASEJUMP  (1,LRnil), ",f);
        fputs("(2,LRcons), LRnil \n",f);
        fputs("LRnil: \n",f);
        fputs("    UPDATE    1 \n",f);
        fputs("    RETURN      \n",f);
        fputs("LRcons: \n",f);
        fputs("    PUSHFUN   Revalarg, 1 \n",f);
        fputs("    MKAP        \n",f);
        fputs("    EVAL        \n",f);
        fputs("    PUSH      1 \n",f);
        fputs("    EVAL        \n",f);
        fputs("    CONS      2, 2 \n",f);
        fputs("    UPDATE    3 \n",f);
        fputs("    POP       2 \n",f);
        fputs("    RETURN    \n\n",f);
        fputs("Rread: \n",f);
        fputs("    PUSH      0 \n",f);
        fputs("    READ        \n",f);
        fputs("    JFAIL     LRend \n",f);
        fputs("    PUSH      1 \n",f);
        fputs("    PUSHFUN   Rread, 1 \n",f);
        fputs("    MKAP        \n",f);
        fputs("    PUSH      1 \n",f);
        fputs("    CONS      2, 2 \n",f);
        fputs("    UPDATE    3 \n",f);
        fputs("    POP       2 \n",f);
        fputs("    RETURN      \n",f);
        fputs("LRend: \n",f);
        fputs("    CONS      1, 0 \n",f);
        fputs("    UPDATE    2 \n",f);
        fputs("    POP       1 \n",f);
        fputs("    RETURN    \n\n",f);
    }
} /* codegen */
