/* el_app.c -- Pass:  Transformation der Anwendungen.  */

#include "elcom.h"

extern int  msg;                            /* elcom.c */
extern int  stop;                           /* elcom.c */
extern char fname[85];                      /* elcom.c */

extern aus_aus(struct ausdruck *, FILE *, int, int);
extern char *newname(void);              /* el_names.c */
extern struct hashtab *newentry(char *, char *,
struct ausdruck *, int);
extern freehash (char *);
/* el_syn.y: */
extern struct ausdruck *b_konst(int, int, char *);
extern struct ausdruck *b_anw(int, struct ausdruck *,
struct ausdruck *);
extern struct ausdruck *b_lambda (struct defliste *,
struct ausdruck *);
extern struct ausdruck *b_let(int, struct defliste *,
struct ausdruck *);
extern struct defliste *b_def(char *, struct ausdruck *);

struct argstack {
    struct argstack *next;
    struct ausdruck *arg;
};

translambda (a)
struct ausdruck *a;
{
    struct ausdruck *p;
    struct defliste *d;
    int             stell;

    /* lambda x.lambda y... --> lambda x y. ... */
    /* Geht, da nach Umbenennung immer: x != y. */
    while (a->links->art == LAMBDA) {
        d = a->definition;
        while (d->next != NULL)
            d = d->next;
        d->next = a->links->definition;
        p = a->links;
        a->links = a->links->links;
        free(p);
        stell = 0;
        d = a->definition;
        while (d != NULL) {
            stell++;
            d = d->next;
        }
        a->stelligkeit = stell;
    }
} /* translambda */

struct ausdruck *konstr (a, c)
struct ausdruck *a;
char            *c;
{
    char *cc;

    cc = new(strlen(c)+1);
    strcpy(cc,c);
    return b_anw(ANW,a,b_konst(VAR,VARNAME,cc));
} /* konstr */

struct ausdruck *apptrans (a, anwrechts)
struct ausdruck *a;
int             anwrechts;
{
    struct argstack *stack, *s;
    struct ausdruck *aret, *p, *pp, *pvor, *u;
    struct ausdruck *t, *temp, *templ;
    struct defliste *d;
    int             i, n, anzahl, ueberarg;
    char            *neu, *neu1, *c;

    switch (a->art) {
    case KONST:
    case VAR:
    case FAIL:
        return a;
    case FATBAR:
        a->links = apptrans(a->links,1);
        a->rechts = apptrans(a->rechts,1);
        return a;
    case LAMBDA:
        translambda(a);
    case MUSTER:
    case SELECT:
        a->links = apptrans(a->links,1);
        return a;
    case IF:
        a->links = apptrans(a->links,1);
        a->rechts = apptrans(a->rechts,1);
        a->rechts->hinten = apptrans(a->rechts->hinten,1);
        return a;
    case CASE:
        a->links = apptrans(a->links,1);
        p = a->rechts;
        while (p != NULL) {
            p = apptrans(p,1);
            p = p->hinten;
        }
        return a;
    case CONS:
        p = a->links;
        while (p != NULL) {
            p = apptrans(p,1);
            p = p->hinten;
        }
        return a;
    case LET:
    case LETREC:
        d = a->definition;
        while (d != NULL) {
            d->varwert = apptrans(d->varwert,1);
            d = d->next;
        }
        a->links = apptrans(a->links,1);
        return a;
    }
    /* Jetzt sind nur noch Anwendungen uebrig. */
    p = pvor = a;
    anzahl = 0;
    while (p->art == ANW) {
        /* Transformation der Argumente */
        if (anwrechts)
            a->rechts = apptrans(a->rechts,1);
        anzahl++;
        pvor = p;
        p = p->links;
    }
    switch (p->art) {
    case LAMBDA:
        c = "LAMBDA";
        break;
    case LET:
        c = "LET";
        break;
    case LETREC:
        c = "LETREC";
        break;
    case CASE:
        c = "CASE";
        break;
    case IF:
        c = "IF";
        break;
    case FATBAR:
        c = "FATBAR";
        break;
    case SELECT:
        c = "SELECT";
        break;
    case VAR:
        return a;
    default:  /* Typfehler */
        fprintf(stderr,"\"%s\" line %d: ",fname,p->beginn);
        fputs("Expression not allowed in application \n",
            stderr);
        if (msg)
            aus_aus(p,stderr,1,0);
        exit(3);
    }
    if (msg == 2) {
        printf("Application line %d: ",a->beginn);
        printf("%s found. %d argument",c,anzahl);
        if (anzahl != 1)
            putchar('s');
        puts(".");
    }
    switch (p->art) {  /* Transformation */
    case LAMBDA:
        translambda(p);
        if (ueberarg = anzahl > p->stelligkeit) {
            aret = a;
            for (i = 1; i++ <= anzahl - p->stelligkeit; ) {
                u = a;
                a = a->links;
                anzahl--;
            }
        }
        p = a;
        stack = NULL;
        while (p->art == ANW) {  /* Argumentstack bauen */
            s = (struct argstack *)
                new(sizeof(struct argstack));
            s->arg = p->rechts;
            s->next = stack;
            stack = s;
            t = p;
            p = p->links;
            free(t);
        }
        temp = NULL;
        while (stack != NULL) { /* Definitionen --> LET's */
            d = p->definition;
            p->definition = d->next;
            d->next = NULL;
            d->varwert = stack->arg;
            t = b_let(LET,d,NULL);
            t->beginn = a->beginn;
            if (temp == NULL)
                temp = templ = t;
            else {
                templ->links = t;
                templ = t;
            }
            s = stack;
            stack = stack->next;
            free(s);
        }
        if (p->definition == NULL) {
            /* Genuegend Argumente fuer das Lambda */
            templ->links = p->links;
            free(p);
        }
        else
            templ->links = p;
        a = temp;
        if (ueberarg) {
            u->links = a;
            a = apptrans(aret,0);
        }
        else
            templ->links = apptrans(templ->links,1);
        break;
    case LET:
    case LETREC:
        pvor->links = p->links;
        p->links = a;
        a = p;
        a->links = apptrans(a->links,0);
        break;
    case IF:
    case CASE:
    case FATBAR:
    case SELECT:
        neu = newname();
        pvor->links = b_konst(VAR,VARNAME,neu);
        neu1 = new(strlen(neu)+1);
        strcpy(neu1,neu);
        p = apptrans(p);
        pp = b_lambda(NULL,p);
        pp->beginn = p->beginn;
        d = b_def(neu1,pp);
        neu1 = new(strlen(neu)+1);
        strcpy(neu1,neu);
        d->sym = newentry(neu,neu1,pp,0);
        pp = b_let(LET,d,a);
        pp->beginn = a->beginn;
        a = pp;
    }
    return a;
} /* apptrans */

subst (alt, neu, a)
char            *alt, *neu;
struct ausdruck *a;
{
    struct ausdruck *p;
    struct defliste *d;

    /* Ersetze im Ausdruck a alt gegen neu. */
    switch (a->art) {
    case KONST:
    case FAIL:
        return;
    case VAR:
        if (!strcmp(a->wert,alt)) {
            free(a->wert);
            a->wert = new(strlen(neu)+1);
            strcpy(a->wert,neu);
        }
        return;
    case IF:
    case CASE:
        subst(alt,neu,a->links);
        p = a->rechts;
        while (p != NULL) {
            subst(alt,neu,p);
            p = p->hinten;
        }
        return;
    case LAMBDA:
    case MUSTER:
    case SELECT:
        subst(alt,neu,a->links);
        return;
    case ANW:
    case FATBAR:
        subst(alt,neu,a->links);
        subst(alt,neu,a->rechts);
        return;
    case CONS:
        p = a->links;
        while (p != NULL) {
            subst(alt,neu,p);
            p = p->hinten;
        }
        return;
    case LET:
    case LETREC:
        d = a->definition;
        while (d != NULL) {
            subst(alt,neu,d->varwert);
            d = d->next;
        }
        subst(alt,neu,a->links);
    }
} /* subst */

struct ausdruck *elim (a)
struct ausdruck *a;
{
    struct ausdruck *p, *pp;
    struct defliste *d, *d1;
    int             first;
    char            *alt, *neu;

    /* Eliminieren unnuetzer Vereinbarungen */
    /* der Art let(rec) x = y ...           */
    switch (a->art) {
    case KONST:
    case VAR:
    case FAIL:
        return a;
    case ANW:
    case FATBAR:
        a->links = elim(a->links);
        a->rechts = elim(a->rechts);
        return a;
    case LAMBDA:
    case MUSTER:
    case SELECT:
        a->links = elim(a->links);
        return a;
    case IF:
    case CASE:
        a->links = elim(a->links);
        p = a->rechts;
        first = 1;
        while (p != NULL) {
            pp = p->hinten;
            p = elim(p);
            p->hinten = pp;
            if (first) {
                a->rechts = p;
                first = 0;
            }
            p = p->hinten;
        }
        return a;
    case CONS:
        p = a->links;
        first = 1;
        while (p != NULL) {
            pp = p->hinten;
            p = elim(p);
            p->hinten = pp;
            if (first) {
                a->links = p;
                first = 0;
            }
            p = p->hinten;
        }
        return a;
    case LET:
    case LETREC:
        d = a->definition;
        while (d != NULL)
            if (d->varwert->art == VAR) {
                /* Definition der Art x = y */
                alt = d->varname;
                neu = d->varwert->wert;
                /* Ausketten: */
                if (d == a->definition)
                    a->definition = d1 = d->next;
                else {
                    d1 = a->definition;
                    while (d1->next != d)
                        d1 = d1->next;
                    d1->next = d->next;
                    d1 = d1->next;
                }
                free(d);
                d = d1;
                /* Substitution: */
                if (a->art == LETREC) {
                    d1 = a->definition;
                    while (d1 != NULL) {
                        subst(alt,neu,d1->varwert);
                        d1 = d1->next;
                    }
                }
                subst(alt,neu,a->links);
                freehash(alt);
            }
            else
                d = d->next;
        if (a->definition == NULL) {
            p = a->links;
            free(a);
            return elim(p);
        }
        d = a->definition;
        while (d != NULL) {
            d->varwert = elim(d->varwert);
            d = d->next;
        }
        a->links = elim(a->links);
        return a;
    }
} /* elim */

neuesniv (d, niv)
struct defliste *d;
int             niv;
{
    while (d != NULL) {
        d->sym->niveau = niv;
        d = d->next;
    }
} /* neuesniv */

neuniv (a, niv)
struct ausdruck *a;
int             niv;
{
    struct ausdruck *p;
    struct defliste *d;

    /* Bindungsniveaus neu berechnen. */
    switch (a->art) {
    case KONST:
    case VAR:
    case FAIL:
        return;
    case ANW:
    case FATBAR:
        neuniv(a->links,niv);
        neuniv(a->rechts,niv);
        return;
    case IF:
        neuniv(a->links,niv);
        neuniv(a->rechts,niv);
        neuniv(a->rechts->hinten,niv);
        return;
    case CONS:
        p = a->links;
        while (p != NULL) {
            neuniv(p,niv);
            p = p->hinten;
        }
        return;
    case SELECT:
        neuniv(a->links,niv);
        return;
    case CASE:
        neuniv(a->links,niv);
        p = a->rechts;
        while (p != NULL) {
            neuniv(p,niv);
            p = p->hinten;
        }
        return;
    case MUSTER:
    case LAMBDA:
        neuesniv(a->definition,niv);
        neuniv(a->links,niv+1);
        return;
    case LET:
        neuesniv(a->definition,niv);
        neuniv(a->definition->varwert,niv);
        neuniv(a->links,niv+1);
        return;
    case LETREC:
        d = a->definition;
        neuesniv(d,niv);
        while (d != NULL) {
            neuniv(d->varwert,niv+1);
            d = d->next;
        }
        neuniv(a->links,niv+1);
    }
} /* neuniv */
