/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
  Interface: ExportException
    Created: 9 January, 2003
        $Id: ExportException.java 41 2006-01-14 15:49:02Z Dirk $
  $Revision: 41 $
      $Date: 2006-01-14 16:49:02 +0100 (Sa, 14 Jan 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.webexport;

import com.dgrossmann.photo.dir.FileObject;

/**
 * Represents an export to Web directory exception.
 */
public class ExportException extends Exception
{
    private FileObject m_fileObj;
    private String     m_msg;
    private Exception  m_e;

    /**
     * Creates a new <tt>ExportException</tt> instance
     * @param fileObj - file object causing the exception
     * @param msg - Message string
     */
    public ExportException
        ( FileObject fileObj
        , String     msg
        )
    {
        m_fileObj = fileObj;
        m_msg = msg;
        m_e = null;
    } // ExportException

    /**
     * Creates a new <tt>ExportException</tt> instance
     * @param fileObj - file object causing the exception
     * @param e - Exception to be wrapped
     */
    public ExportException
        ( FileObject fileObj
        , Exception  e
        )
    {
        m_fileObj = fileObj;
        m_msg = null;
        m_e = e;
    } // ExportException

    /**
     * Gets the exception message.
     * @return Exception message
     */
    public String getMessage ()
    {
        String msg;

        msg = "Cannot export file \"" + m_fileObj.getFileName() + "\"\n";
        if (m_msg != null && m_msg.length() > 0)
            msg += msg;
        else if (m_e != null)
            msg += m_e.toString();
        return msg;
    } // getMessage

    /** Logs the exception to the standard error output. */
    public void log ()
    {
        System.err.println("E: " + this.getMessage());
        if (m_e != null)
            m_e.printStackTrace();
    } // log
} // ExportException
