/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: IExplorerPanel
    Created: 17.12.2005 (13:28:45)
        $Id: IExplorerPanel.java 159 2009-05-19 19:40:47Z dirk $
  $Revision: 159 $
      $Date: 2009-05-19 21:40:47 +0200 (Di, 19 Mai 2009) $
    $Author: dirk $
===============================================================================
*/

package com.dgrossmann.photo.ui.panel;

import java.util.List;

import javax.swing.JPanel;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.settings.Settings;

/**
 * Interface that all panel components of the JPhoto-Explorer main window
 * implement.
 * @author Dirk Grossmann
 */
public interface IExplorerPanel
{
    /**
     * Gets the root component, typically this.
     * @return This
     */
    public JPanel getRootComponent();

    /**
     * Called after the window has been realized to adjust subcomponent sizes.
     */
    public void setupComponents();

    /**
     * Instructs the panel to load its settings.
     * @param settings - The settings object to use
     */
    public void loadSettings (Settings settings);

    /**
     * Instructs the panel to load its settings.
     * @param settings - The settings object to use
     */
    public void saveSettings (Settings settings);

    /**
     * Adds a change listener.
     * @param listener - The listener to add
     */
    public void addChangeListener (IExplorerPanelChangeListener listener);

    /**
     * Adds a change listener.
     * @param listener - The listener to remove
     */
    public void removeChangeListener (IExplorerPanelChangeListener listener);

    /**
     * Causes the panel's title to be drawn in the color for the activated
     * frame.
     */
    public void setActiveColors();

    /**
     * Causes the panel's title to be drawn in the color for the inactivated
     * frame.
     */
    public void setInactiveColors();

    /**
     * Sets the current directory.
     * @param fsObj - The current directory object
     */
    public void setCurrentDirectory(DirectoryObject fsObj);

    /**
     * Sets the file object whose properties should be displayed.
     * @param fsObj - The current file system object
     */
    public void setCurrentFSObject(AbstractFSObject fsObj);

    /**
     * Sets the file objects whose properties should be displayed.
     * @param fsObjs - The list of current file system objects
     */
    public void setCurrentFSObjects(List<AbstractFSObject> fsObjs);

    /**
     * Saves changes from the components to the underlying data objects.
     * May be called before {@link #refresh()}.
     */
    public void saveChanges();

    /**
     * Refreshes the view of the panel (without having set new current file
     * system objects).
     */
    public void refresh();
} // IExplorerPanel
