/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: TextViewDialog
    Created: 2 January, 2003
        $Id: TextViewDialog.java 41 2006-01-14 15:49:02Z Dirk $
  $Revision: 41 $
      $Date: 2006-01-14 16:49:02 +0100 (Sa, 14 Jan 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.ui.dialog;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.FileReader;

import javax.swing.JDialog;
import javax.swing.JOptionPane;

import com.dgrossmann.photo.AppInfo;

/**
 * The <i>text file view</i> dialog class.
 */
public class TextViewDialog extends JDialog
{
    /**
     * Creates a new <tt>TextViewDialog</tt> form instance.
     * @param parent - Parent frame in the user interface
     * @param title - Dialog title
     * @param textFilePath - Full path of the text file to be shown
     * @param modal - <tt>True</tt> for a modal dialog
     */
    public TextViewDialog
        ( Frame   parent
        , String  title
        , String  textFilePath
        , boolean modal)
    {
        super(parent, modal);
        this.initialize(title, textFilePath);
    } // TextViewDialog

    /**
     * Creates a new <tt>TextViewDialog</tt> form instance.
     * @param parent - Parent dialog in the user interface
     * @param title - Dialog title
     * @param textFilePath - Full path of the text file to be shown
     * @param modal - <tt>True</tt> for a modal dialog
     */
    public TextViewDialog
        ( Dialog  parent
        , String  title
        , String  textFilePath
        , boolean modal
        )
    {
        super(parent, modal);
        this.initialize(title, textFilePath);
    } // TextViewDialog

    /**
     * Private method to initializes this dialog instance.
     * @param title - The window title
     * @param textFilePath - Path to the text file to be displayed
     */
    private void initialize (String  title, String  textFilePath)
    {
        this.initComponents();
        // Set the contents.
        String tit = (title != null) ? title : " ";
        if (tit.length() > 1)
            tit += " - ";
        tit += "Text View";
        this.setTitle(tit);
        titleLabel.setText(textFilePath);
        // Read the text file.
        BufferedReader in = null;
        StringBuffer fileContents = new StringBuffer(10000);
        String line;
        try
        {
            in = new BufferedReader(new FileReader(textFilePath));
            while ((line = in.readLine()) != null)
                fileContents.append(line).append('\n');
        }
        catch (Exception e)
        {
            JOptionPane.showMessageDialog
                (this, "Cannot display file \"" + textFilePath
                + "\"\nError: " + e, AppInfo.APP_NAME,
                JOptionPane.ERROR_MESSAGE);
        }
        finally
        {
            try
            {
                if (in != null)
                    in.close();
            }
            catch (Exception ex)
            {
            }
        }
        // Display the text in the text area.
        if (fileContents.length() > 0)
        {
            contentsTextArea.setText(fileContents.toString());
            contentsTextArea.setCaretPosition(0);
        }
        // Set the dialog position.
        Toolkit   tk = Toolkit.getDefaultToolkit();
        Dimension siz = tk.getScreenSize();
        Rectangle frameRect = new Rectangle();
        frameRect.width = 950;
        if (frameRect.width >= siz.width)
            frameRect.width = siz.width;
        frameRect.height = siz.height - 34;
        frameRect.x = 0;
        frameRect.y = 0;
        this.setBounds(frameRect);
    } // initialize

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents()//GEN-BEGIN:initComponents
    {
        titleLabel = new javax.swing.JLabel();
        textScrollPane = new javax.swing.JScrollPane();
        contentsTextArea = new javax.swing.JTextArea();
        buttonPanel = new javax.swing.JPanel();
        closeButton = new javax.swing.JButton();

        addWindowListener(new java.awt.event.WindowAdapter()
        {
            public void windowClosing(java.awt.event.WindowEvent evt)
            {
                closeDialog(evt);
            }
        });

        titleLabel.setText(" ");
        getContentPane().add(titleLabel, java.awt.BorderLayout.NORTH);

        contentsTextArea.setColumns(40);
        contentsTextArea.setFont(new java.awt.Font("Monospaced", 0, 14));
        contentsTextArea.setRows(30);
        contentsTextArea.setTabSize(4);
        textScrollPane.setViewportView(contentsTextArea);

        getContentPane().add(textScrollPane, java.awt.BorderLayout.CENTER);

        buttonPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                closeButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(closeButton);

        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_closeButtonActionPerformed
    {//GEN-HEADEREND:event_closeButtonActionPerformed
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_closeButtonActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt)
    {//GEN-FIRST:event_closeDialog
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_closeDialog
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel titleLabel;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JScrollPane textScrollPane;
    private javax.swing.JTextArea contentsTextArea;
    private javax.swing.JButton closeButton;
    // End of variables declaration//GEN-END:variables
    
} // TextViewDialog
