/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
  Interface: IDirPersist
    Created: 2 January, 2003
        $Id: IDirPersist.java 76 2006-03-29 19:16:10Z Dirk $
  $Revision: 76 $
      $Date: 2006-03-29 21:16:10 +0200 (Mi, 29 Mrz 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.dir.persist;

import com.dgrossmann.photo.dir.DirectoryObject;

/**
 * Interface to be implemented by persister classes that persist the meta
 * information for a photo series (containing subdirectories [groups], files,
 * and images).
 */
public interface IDirPersist
{
    /**
     * Checks whether this instance can load the series directory
     * <tt>seriesDirObj</tt>.
     * @param seriesDirObj - Series root directory obbject. It should be set up
     * with the absolute path of the directory, but is otherwise empty.
     * @return <tt>True</tt> if this instance can load the series
     */
    public boolean canLoad (DirectoryObject seriesDirObj);

    /**
     * Loads the information for the directory <tt>seriesDirObj</tt> from the
     * file system and the meta data repository.
     * @param seriesDirObj - Series root directory obbject. It should be set up
     * with the absolute path of the directory, but is otherwise empty.
     * @throws PersistException
     */
    public void load (DirectoryObject seriesDirObj)
        throws PersistException;

    /**
     * Saves the information for the series directory <tt>seriesDirObj</tt> and
     * its subobjects into the meta data repository.
     * @param seriesDirObj - Series root directory obbject to be saved
     * @param bForce - <tt>True</tt> to force saving
     * @throws PersistException
     */
    public void save (DirectoryObject seriesDirObj, boolean bForce)
        throws PersistException;

    /**
     * Saves the information for the series directory <tt>seriesDirObj</tt> and
     * its subobjects into the meta data repository for the Web.
     * @param seriesDirObj - Series root directory obbject to be exported for
     * the Web
     * @throws PersistException
     */
    public void saveForWeb (DirectoryObject seriesDirObj)
        throws PersistException;
} // IDirPersist
