/*
 * Decompiled with CFR 0.152.
 */
package magick;

import java.awt.Dimension;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Vector;
import magick.Magick;
import magick.MagickException;
import magick.MagickImage;

public class MagickProducer
extends Magick
implements ImageProducer {
    private MagickImage image = null;
    private Vector consumers = null;

    public MagickProducer(MagickImage magickImage) {
        this.image = magickImage;
        this.consumers = new Vector();
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (imageConsumer != null && !this.consumers.contains(imageConsumer)) {
            this.consumers.addElement(imageConsumer);
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.removeElement(imageConsumer);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        int n;
        byte[] byArray;
        int n2;
        Dimension dimension;
        this.addConsumer(imageConsumer);
        try {
            dimension = this.image.getDimension();
            n2 = dimension.width * dimension.height;
            byArray = new byte[n2 * 4];
            this.image.dispatchImage(0, 0, dimension.width, dimension.height, "RGBA", byArray);
        }
        catch (MagickException magickException) {
            for (int i = 0; i < this.consumers.size(); ++i) {
                ImageConsumer imageConsumer2 = (ImageConsumer)this.consumers.elementAt(i);
                imageConsumer2.imageComplete(1);
            }
            return;
        }
        int[] nArray = new int[n2];
        DirectColorModel directColorModel = new DirectColorModel(32, -16777216, 0xFF0000, 65280, 255);
        for (n = 0; n < n2; ++n) {
            nArray[n] = (byArray[n * 4] & 0xFF) << 24 | (byArray[n * 4 + 1] & 0xFF) << 16 | (byArray[n * 4 + 2] & 0xFF) << 8 | byArray[n * 4 + 3] & 0xFF;
        }
        for (n = 0; n < this.consumers.size(); ++n) {
            ImageConsumer imageConsumer3 = (ImageConsumer)this.consumers.elementAt(n);
            imageConsumer3.setHints(30);
            imageConsumer3.setDimensions(dimension.width, dimension.height);
            imageConsumer3.setPixels(0, 0, dimension.width, dimension.height, (ColorModel)directColorModel, nArray, 0, dimension.width);
            imageConsumer3.imageComplete(3);
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }
}

