/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.webexport;

import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.webexport.BaseExporter;
import com.dgrossmann.photo.webexport.ExportException;
import com.dgrossmann.photo.webexport.ExportProgress;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class JavaExporter
extends BaseExporter {
    @Override
    public String getDescription() {
        return "Internal conversion (for better quality, use ImageMagick)";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    private Image writeScaledImage(Image sourceImage, int sourceImageType, Dimension size, int quality, String copyrightStr, File destFile) throws Exception {
        Image scaledImage = sourceImage.getScaledInstance(size.width, size.height, 4);
        MediaTracker track = new MediaTracker(this.m_parent);
        track.addImage(scaledImage, 0);
        try {
            track.waitForAll();
        }
        catch (InterruptedException iexc) {
            // empty catch block
        }
        BufferedImage imageToWrite = new BufferedImage(size.width, size.height, 1);
        Graphics2D gr = imageToWrite.createGraphics();
        boolean bReady = gr.drawImage(scaledImage, 0, 0, null);
        if (!bReady) {
            try {
                Thread.sleep(75L);
            }
            catch (Exception sleepEx) {
                // empty catch block
            }
        }
        if (copyrightStr != null) {
            Font fn = gr.getFont();
            fn = fn.deriveFont(1, 9.0f);
            FontMetrics fmetrics = gr.getFontMetrics(fn);
            Rectangle2D box = fmetrics.getStringBounds(copyrightStr, gr);
            gr.setColor(Color.BLACK);
            gr.drawString(copyrightStr, (int)((double)size.width - box.getWidth() - 31.0), size.height - fmetrics.getDescent());
            gr.setColor(Color.WHITE);
            gr.drawString(copyrightStr, (int)((double)size.width - box.getWidth() - 32.0), size.height - fmetrics.getDescent() - 1);
        }
        try {
            ImageIO.write((RenderedImage)imageToWrite, "jpeg", destFile);
        }
        catch (Exception e) {
            System.err.println("E: Exception during image write.\n   " + e);
            e.printStackTrace();
            ImageIO.write((RenderedImage)imageToWrite, "jpeg", destFile);
        }
        sourceImage.flush();
        imageToWrite.flush();
        return scaledImage;
    }

    @Override
    protected void exportFile(FileObject fileObj, ExportProgress progress) throws ExportException {
        try {
            Image scaledImage;
            File f;
            BufferedImage origImage = ImageIO.read(new File(fileObj.getFullPath()));
            int imageType = origImage.getType();
            if (imageType <= 0) {
                imageType = 2;
            }
            Dimension size = new Dimension();
            size.width = origImage.getWidth();
            size.height = origImage.getHeight();
            progress.setOriginalSize(size);
            this.fillImageSizes(progress);
            if (!progress.isMainUpToDate()) {
                size = progress.getMainSize();
                f = new File(progress.getOutputDirectory() + File.separator + progress.getMainFileName());
                scaledImage = this.writeScaledImage(origImage, imageType, size, this.getConversionQuality(fileObj, true), this.getCopyrightString(fileObj), f);
                origImage = null;
            } else {
                scaledImage = origImage;
            }
            progress.setMainReady(true);
            if (!progress.isIndexUpToDate()) {
                size = progress.getIndexSize();
                f = new File(progress.getOutputDirectory() + File.separator + progress.getIndexFileName());
                this.writeScaledImage(scaledImage, imageType, size, this.getConversionQuality(fileObj, false), null, f);
            }
            scaledImage = null;
            progress.setIndexReady(true);
        }
        catch (Exception exc) {
            throw new ExportException(fileObj, exc);
        }
        Runtime.getRuntime().gc();
    }
}

