/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.webexport;

import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.dir.SeriesContainer;
import com.dgrossmann.photo.settings.Settings;
import com.dgrossmann.photo.ui.ExplorerMainFrame;
import com.dgrossmann.photo.webexport.ExportException;
import com.dgrossmann.photo.webexport.ExportFactory;
import com.dgrossmann.photo.webexport.ExportProgress;
import com.dgrossmann.photo.webexport.IWebExport;
import java.util.Iterator;
import java.util.List;

public class ExportThread
extends Thread
implements Runnable {
    private Settings m_settings;
    private SeriesContainer m_seriesContainer;
    private ExplorerMainFrame m_frame;
    private List<FileObject> m_exportList;
    private int m_whatToExport;
    private boolean m_bForce;

    public ExportThread(List<FileObject> exportList, Settings settings, SeriesContainer sContainer, ExplorerMainFrame frm) {
        this.m_exportList = exportList;
        this.m_settings = settings;
        this.m_seriesContainer = sContainer;
        this.m_frame = frm;
        this.m_whatToExport = 1;
        this.m_bForce = false;
    }

    public void setExportOptions(boolean bMain, boolean bIndex, boolean bForce) {
        this.m_whatToExport = bMain && bIndex ? 1 : (bMain ? 2 : (bIndex ? 3 : 0));
        this.m_bForce = bForce;
    }

    @Override
    public void run() {
        ExportProgress progress = null;
        IWebExport exp = ExportFactory.getExport(this.m_settings, this.m_seriesContainer, this.m_frame);
        this.m_frame.exportSetReady(false);
        try {
            Iterator<FileObject> iter = this.m_exportList.iterator();
            int currentFileNumber = 0;
            while (iter.hasNext()) {
                FileObject fileObj = iter.next();
                ++currentFileNumber;
                int outOfMemoryCount = 0;
                while (fileObj != null) {
                    try {
                        progress = new ExportProgress(fileObj, currentFileNumber);
                        this.m_frame.setExportProgress(progress);
                        if (fileObj.getFileType() == 1) {
                            exp.export(progress, this.m_whatToExport, this.m_bForce);
                        } else {
                            exp.copy(progress, this.m_bForce);
                        }
                        fileObj = null;
                    }
                    catch (OutOfMemoryError me) {
                        if (++outOfMemoryCount > 4) {
                            throw new ExportException(fileObj, "Out of memory");
                        }
                        try {
                            Thread.sleep(333 + outOfMemoryCount * 555);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        Runtime.getRuntime().gc();
                    }
                }
                if (!this.m_frame.m_exportStop) continue;
                this.m_frame.exportSetReady(true);
                this.m_frame.setExportProgress(null);
                return;
            }
        }
        catch (Exception e) {
            System.err.println("E: Export (thread) exception:\n" + e);
            e.printStackTrace();
            this.m_frame.exportSetError(e.getMessage());
        }
        this.m_frame.exportSetReady(true);
        this.m_frame.setExportProgress(null);
    }
}

