/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.webexport;

import com.dgrossmann.photo.dir.SeriesContainer;
import com.dgrossmann.photo.settings.Settings;
import com.dgrossmann.photo.webexport.IWebExport;
import com.dgrossmann.photo.webexport.ImageMagickExporter;
import com.dgrossmann.photo.webexport.JavaExporter;
import java.awt.Component;

public class ExportFactory {
    private static IWebExport s_magickExporter = null;
    private static IWebExport s_javaExporter = null;

    public static IWebExport getExport(Settings settings, SeriesContainer sContainer, Component parent) {
        int useMagick = settings.getInt("export.use_magick", 0);
        if (useMagick > 0) {
            if (s_magickExporter == null) {
                s_magickExporter = new ImageMagickExporter();
                s_magickExporter.setEnvironment(settings, sContainer, parent);
            }
            if (s_magickExporter.isAvailable()) {
                return s_magickExporter;
            }
        }
        if (s_javaExporter == null) {
            s_javaExporter = new JavaExporter();
            s_javaExporter.setEnvironment(settings, sContainer, parent);
        }
        return s_javaExporter;
    }
}

