/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.webexport;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.dir.SeriesContainer;
import com.dgrossmann.photo.settings.Settings;
import com.dgrossmann.photo.webexport.ExportException;
import com.dgrossmann.photo.webexport.ExportProgress;
import com.dgrossmann.photo.webexport.IWebExport;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class BaseExporter
implements IWebExport {
    protected Settings m_settings = null;
    protected SeriesContainer m_seriesContainer = null;
    protected Component m_parent = null;

    @Override
    public void setEnvironment(Settings settings, SeriesContainer sContainer, Component parent) {
        this.m_settings = settings;
        this.m_seriesContainer = sContainer;
        this.m_parent = parent;
    }

    protected String getCopyrightString(FileObject fileObj) {
        String copyrightStr = this.m_settings.get("gallery.copyright");
        if (copyrightStr == null || copyrightStr.trim().length() == 0) {
            return null;
        }
        int i = copyrightStr.indexOf("${year}");
        if (i > 0) {
            Integer year = fileObj.getYear();
            copyrightStr = copyrightStr.substring(0, i) + (year != null ? year.toString() : "") + copyrightStr.substring(i + 7);
        }
        return copyrightStr;
    }

    private Dimension getNewSize(Dimension origSize, boolean bIsMain) {
        Dimension newSize = new Dimension();
        if (!bIsMain) {
            int prefLength = this.m_settings.getInt("export.indeximg.length", 200);
            if (Math.max(origSize.width, origSize.height) <= prefLength) {
                newSize.width = origSize.width;
                newSize.height = origSize.height;
            } else if (origSize.width >= origSize.height) {
                int newHeight = origSize.height * prefLength / origSize.width;
                newSize.width = prefLength;
                newSize.height = newHeight;
            } else {
                int newWidth;
                newSize.width = newWidth = origSize.width * prefLength / origSize.height;
                newSize.height = prefLength;
            }
            return newSize;
        }
        int prefLength = this.m_settings.getInt("export.mainimg.length", 600);
        int maxWidth = this.m_settings.getInt("export.mainimg.max_width", 700);
        int maxHeight = this.m_settings.getInt("export.mainimg.max_height", 450);
        if (Math.max(origSize.width, origSize.height) <= prefLength) {
            newSize.width = origSize.width;
            newSize.height = origSize.height;
        } else if (origSize.height + origSize.height / 10 >= origSize.width) {
            int newWidth;
            if (prefLength > maxHeight) {
                prefLength = maxHeight;
            }
            newSize.width = newWidth = origSize.width * prefLength / origSize.height;
            newSize.height = prefLength;
            if (newSize.width < newSize.height / 2 && prefLength < maxHeight) {
                newSize.width = newWidth = origSize.width * maxHeight / origSize.height;
                newSize.height = maxHeight;
            }
        } else {
            int newHeight = origSize.height * prefLength / origSize.width;
            newSize.width = prefLength;
            newSize.height = newHeight;
            if (newSize.height < newSize.width / 2) {
                newHeight = origSize.height * maxWidth / origSize.width;
                newSize.width = maxWidth;
                newSize.height = newHeight;
            }
        }
        return newSize;
    }

    protected void fillImageSizes(ExportProgress progress) {
        Dimension origSize = progress.getOriginalSize();
        if (origSize == null) {
            return;
        }
        if (!progress.isMainUpToDate()) {
            progress.setMainSize(this.getNewSize(origSize, true));
        }
        if (!progress.isIndexUpToDate()) {
            progress.setIndexSize(this.getNewSize(origSize, false));
        }
    }

    public int getConversionQuality(AbstractFSObject fileObj, boolean bMain) {
        int quality = 0;
        for (AbstractFSObject fsObj = fileObj; fsObj != null && quality == 0; fsObj = fsObj.getParent()) {
            quality = fsObj.getConversionQuality();
        }
        if (quality > 0) {
            return quality;
        }
        if (bMain) {
            return this.m_settings.getInt("export.mainimg.quality", 85);
        }
        return this.m_settings.getInt("export.indeximg.quality", 75);
    }

    protected abstract void exportFile(FileObject var1, ExportProgress var2) throws ExportException;

    private File prepareOutputDir(ExportProgress progress) throws ExportException {
        FileObject fileObj = progress.getFileObject();
        ArrayList<String> parents = new ArrayList<String>();
        DirectoryObject seriesDir = (DirectoryObject)fileObj.getParent();
        if (seriesDir == null) {
            throw new ExportException(fileObj, "The file does not have a parent directory object");
        }
        while (seriesDir.getParent() != null) {
            parents.add(0, seriesDir.getFileName().toLowerCase());
            seriesDir = (DirectoryObject)seriesDir.getParent();
        }
        if (!this.m_seriesContainer.isSeriesDirectory(seriesDir)) {
            throw new ExportException(fileObj, "The file does not have a valid series directory: " + seriesDir.getTitle(true));
        }
        File dir = new File(this.m_settings.get("export.dir"));
        if (!dir.isDirectory()) {
            throw new ExportException(fileObj, dir.toString() + " is not a valid Web export directory");
        }
        boolean bOK = true;
        if (!(dir = new File(dir, seriesDir.getFileName().toLowerCase())).isDirectory()) {
            bOK = dir.mkdir();
        }
        Iterator iter = parents.iterator();
        while (bOK && iter.hasNext()) {
            dir = new File(dir, (String)iter.next());
            if (!bOK || dir.isDirectory()) continue;
            bOK = dir.mkdir();
        }
        if (!bOK) {
            throw new ExportException(fileObj, "Cannot create directory: " + dir);
        }
        progress.setOutputDirectory(dir.getAbsolutePath());
        return dir;
    }

    @Override
    public void export(ExportProgress progress, int whatToExport, boolean bForce) throws ExportException {
        FileObject fileObj = progress.getFileObject();
        File dir = this.prepareOutputDir(progress);
        String str = fileObj.getBaseFileName().toLowerCase();
        String name = str + ".jpg";
        progress.setMainFileName(name);
        long origMod = new File(fileObj.getFullPath()).lastModified();
        File destFile = new File(dir, name);
        long expMod = destFile.exists() ? destFile.lastModified() : 0L;
        if (bForce || origMod > expMod) {
            progress.setMainUpToDate(false);
        } else {
            progress.setMainUpToDate(true);
        }
        name = str + "-s.jpg";
        progress.setIndexFileName(name);
        destFile = new File(dir, name);
        expMod = destFile.exists() ? destFile.lastModified() : 0L;
        if (bForce || origMod > expMod) {
            progress.setIndexUpToDate(false);
        } else {
            progress.setIndexUpToDate(true);
        }
        if (whatToExport == 0) {
            return;
        }
        if (whatToExport == 2) {
            progress.setIndexUpToDate(true);
        } else if (whatToExport == 3) {
            progress.setMainUpToDate(true);
        }
        if (!progress.isMainUpToDate() || !progress.isIndexUpToDate()) {
            this.exportFile(fileObj, progress);
        }
    }

    @Override
    public void copy(ExportProgress progress, boolean bForce) throws ExportException {
        FileObject fileObj = progress.getFileObject();
        File dir = this.prepareOutputDir(progress);
        String name = fileObj.getFileName().toLowerCase();
        progress.setMainFileName(name);
        File srcFile = new File(fileObj.getFullPath());
        File destFile = new File(dir, name);
        long expMod = destFile.exists() ? destFile.lastModified() : 0L;
        if (!bForce && srcFile.lastModified() <= expMod) {
            progress.setMainUpToDate(true);
            return;
        }
        progress.setMainUpToDate(false);
        FileInputStream in = null;
        FileOutputStream out = null;
        byte[] buf = new byte[32768];
        try {
            int len;
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            throw new ExportException(fileObj, "Cannot copy file \"" + srcFile.toString() + "\" to \"" + destFile.toString() + "\"");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exc) {}
        }
    }

    @Override
    public File[] getExportedFiles(AbstractFSObject fsObj) {
        File[] str = new File[2];
        str[1] = null;
        str[0] = null;
        DirectoryObject seriesDir = (DirectoryObject)fsObj.getParent();
        DirectoryObject parentDir = seriesDir;
        if (parentDir == null) {
            return str;
        }
        while (seriesDir.getParent() != null) {
            seriesDir = (DirectoryObject)seriesDir.getParent();
        }
        File dir = new File(this.m_settings.get("export.dir"), parentDir.getPath(true).toLowerCase());
        if (fsObj instanceof DirectoryObject) {
            return str;
        }
        if (fsObj instanceof FileObject) {
            String name = ((FileObject)fsObj).getBaseFileName().toLowerCase();
            File f = new File(dir, name + ".jpg");
            if (f.exists()) {
                str[0] = f;
            }
            if ((f = new File(dir, name + "-s.jpg")).exists()) {
                str[1] = f;
            }
        }
        return str;
    }

    @Override
    public void renameExportedFiles(AbstractFSObject oldFsObj, DirectoryObject newParent, String newName) throws ExportException {
        File newFile;
        File oldFile;
        File exportDir = new File(this.m_settings.get("export.dir"));
        DirectoryObject newParentDirObj = newParent != null ? newParent : (DirectoryObject)oldFsObj.getParent();
        File newPDir = newParentDirObj == null ? exportDir : new File(exportDir, newParentDirObj.getPath(true).toLowerCase());
        if (oldFsObj instanceof DirectoryObject) {
            File newDir;
            File oldDir;
            if (newName != null) {
                newName = newName.toLowerCase();
            }
            if (!(oldDir = new File(exportDir, oldFsObj.getPath(true).toLowerCase())).renameTo(newDir = new File(newPDir, newName != null ? newName : oldFsObj.getFileName().toLowerCase()))) {
                System.err.println("W: Cannot rename exported directory from:\n   " + oldDir.getAbsolutePath() + "\nto:\n   " + newDir.getAbsolutePath());
            }
            return;
        }
        if (!(oldFsObj instanceof FileObject)) {
            return;
        }
        FileObject fileObj = (FileObject)oldFsObj;
        File oldDir = oldFsObj.getParent() == null ? exportDir : new File(exportDir, oldFsObj.getParent().getPath(true).toLowerCase());
        String oldBaseName = fileObj.getBaseFileName();
        String newBaseName = newName != null ? newName : fileObj.getBaseFileName();
        int i = newBaseName.indexOf(".");
        if (i > 0) {
            newBaseName = newBaseName.substring(0, i);
        }
        if (!(oldFile = new File(oldDir, oldBaseName + ".jpg")).renameTo(newFile = new File(newPDir, newBaseName + ".jpg"))) {
            System.err.println("W: Cannot rename exported main file from:\n   " + oldFile.getAbsolutePath() + "\nto:\n   " + newFile.getAbsolutePath());
        }
        if (!(oldFile = new File(oldDir, oldBaseName + "-s.jpg")).renameTo(newFile = new File(newPDir, newBaseName + "-s.jpg"))) {
            System.err.println("W: Cannot rename exported index file from:\n   " + oldFile.getAbsolutePath() + "\nto:\n   " + newFile.getAbsolutePath());
        }
    }

    @Override
    public void deleteExportedFiles(AbstractFSObject fsObj, int whatTodelete) throws ExportException {
        DirectoryObject seriesDir = (DirectoryObject)fsObj.getParent();
        DirectoryObject parentDir = seriesDir;
        if (parentDir == null) {
            return;
        }
        while (seriesDir.getParent() != null) {
            seriesDir = (DirectoryObject)seriesDir.getParent();
        }
        File dir = new File(this.m_settings.get("export.dir"), parentDir.getPath(true).toLowerCase());
        if (!dir.isDirectory()) {
            return;
        }
        if (!(fsObj instanceof DirectoryObject) && fsObj instanceof FileObject) {
            File f;
            String name = ((FileObject)fsObj).getBaseFileName().toLowerCase();
            if (whatTodelete == 1 || whatTodelete == 2) {
                f = new File(dir, name + ".jpg");
                f.delete();
            }
            if (whatTodelete == 1 || whatTodelete == 3) {
                f = new File(dir, name + "-s.jpg");
                f.delete();
            }
        }
    }
}

