/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.panel.contents;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.settings.Settings;
import com.dgrossmann.photo.ui.ExplorerMainFrame;
import com.dgrossmann.photo.ui.ShellExec;
import com.dgrossmann.photo.ui.dialog.AssociateDialog;
import com.dgrossmann.photo.ui.dialog.ExportedImageViewDialog;
import com.dgrossmann.photo.ui.dialog.PropertiesDialog;
import com.dgrossmann.photo.ui.panel.AbstractExplorerPanel;
import com.dgrossmann.photo.ui.panel.PanelTitleChangeListener;
import com.dgrossmann.photo.ui.panel.contents.ContentsPreviewManager;
import com.dgrossmann.photo.ui.panel.contents.ContentsTableModel;
import com.dgrossmann.photo.ui.panel.contents.ContentsTableMouseListener;
import com.dgrossmann.photo.webexport.ExportException;
import com.dgrossmann.photo.webexport.ExportFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ContentsPanel
extends AbstractExplorerPanel
implements ListSelectionListener,
ActionListener,
FocusListener,
PanelTitleChangeListener {
    public static final String DBL_CLICK_DIR_OPENS = "contents.dbl_click_on_dir_opens";
    public static final String DBL_CLICK_FILE_OPENS = "contents.dbl_click_on_file_opens";
    private static final String CONT_COLUMN_POS = "contents.column_pos.";
    private static final String CONT_SHOW_PREVIEW = "contents.show_preview";
    private static final String CONTENTS_PANE_TITLE = "Contents";
    private static final String NEWITEM_FILE = "File";
    private static final String NEWITEM_SUBGROUP = "Subgroup";
    private static final String NEWITEM_REFERENCE = "Reference";
    private static final String NEWITEM_SEPARATOR = "Separator";
    private static final int SCREEN_WIDTH_THRESH = 1200;
    private static final int TABLE_ROW_SIZE = 52;
    private static final int SZ_IMAGE_WIDTH_L = 62;
    private static final int SZ_NAME_S = 180;
    private static final int SZ_NAME_L = 250;
    private static final int SZ_MODIFIED_WIDTH_S = 102;
    private static final int SZ_MODIFIED_WIDTH_L = 144;
    private static final int SZ_EXPORT_WIDTH_S = 48;
    private static final int SZ_EXPORT_WIDTH_L = 58;
    private ContentsTableModel m_fileTableModel;
    private boolean m_bDblClickOnDirOpens;
    private boolean m_bDblClickOnFileOpens;
    private boolean m_bIsPreviewShowing;
    private ContentsPreviewManager m_previewManager;
    private JPopupMenu m_filePopupMenu;
    private JMenuItem m_fpOpen;
    private JMenuItem m_fpShowExported;
    private JMenuItem m_fpProperties;
    private JMenuItem m_fpCut;
    private JMenuItem m_fpAssociate;
    private JMenuItem m_fpDelete;
    private JMenuItem m_fpMoveUp;
    private JMenuItem m_fpMoveDown;
    private JPanel aspectsPanel;
    private JPanel buttonPanel;
    private JPanel contentsPanel;
    private JButton delButton;
    private JEditorPane htmlPane;
    private JScrollPane jScrollPane1;
    private JScrollPane listScrollPane;
    private JTable listTable;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton newObjButton;
    private JPanel newObjPanel;
    private JComboBox newObjSelComboBox;
    private JButton orderByFileNameButton;
    private JButton pasteButton;
    private JPanel previewCenterPanel;
    private JPanel previewPanel;
    private JButton propertiesButton;
    private JLabel separatorLabel;
    private JLabel separatorLabel1;
    private JLabel separatorLabel2;
    private JLabel separatorLabel3;

    public ContentsPanel(ExplorerMainFrame frm) {
        super(frm, CONTENTS_PANE_TITLE);
        this.m_fileTableModel = new ContentsTableModel(this.getRootComponent(), this, frm.getImageHolder());
        this.m_filePopupMenu = null;
        this.m_bIsPreviewShowing = false;
        this.initComponents();
        this.add((Component)this.getTitleLabel(), "North");
        this.m_previewManager = new ContentsPreviewManager(this, this.htmlPane);
        this.newObjSelComboBox.addItem(NEWITEM_FILE);
        this.newObjSelComboBox.addItem(NEWITEM_SUBGROUP);
        this.newObjSelComboBox.addItem(NEWITEM_REFERENCE);
        this.newObjSelComboBox.addItem(NEWITEM_SEPARATOR);
        this.newObjSelComboBox.setSelectedItem(NEWITEM_SEPARATOR);
        ListSelectionModel lsModel = this.listTable.getSelectionModel();
        lsModel.setSelectionMode(2);
        lsModel.addListSelectionListener(this);
        this.listTable.addMouseListener(new ContentsTableMouseListener(this));
        this.listTable.addFocusListener(this);
        this.setCurrentDirectory(null);
    }

    @Override
    public void setupComponents() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        TableColumnModel cModel = this.listTable.getColumnModel();
        JTableHeader thead = this.listTable.getTableHeader();
        Dimension thSize = thead.getPreferredSize();
        if (thSize.height < 18) {
            thSize.height = 18;
        }
        thead.setPreferredSize(thSize);
        this.listTable.setRowHeight(52);
        this.listTable.setRowMargin(1);
        this.listTable.setShowHorizontalLines(true);
        this.listTable.setGridColor(new Color(233, 233, 222));
        int sumColWidths = 0;
        int colWidth = screenSize.width > 1200 ? 62 : 52;
        TableColumn col = cModel.getColumn(0);
        col.setMinWidth(colWidth);
        col.setPreferredWidth(colWidth);
        sumColWidths += colWidth;
        colWidth = screenSize.width > 1200 ? 250 : 180;
        col = cModel.getColumn(1);
        col.setMinWidth(0);
        col.setPreferredWidth(colWidth);
        sumColWidths += colWidth;
        colWidth = screenSize.width > 1200 ? 144 : 102;
        col = cModel.getColumn(3);
        col.setMinWidth(0);
        col.setPreferredWidth(colWidth);
        sumColWidths += colWidth;
        colWidth = screenSize.width > 1200 ? 58 : 48;
        col = cModel.getColumn(4);
        col.setMinWidth(0);
        col.setPreferredWidth(colWidth);
        sumColWidths += colWidth;
        JScrollBar tempSB = new JScrollBar();
        Dimension prefSBSize = tempSB.getUI().getPreferredSize(tempSB);
        if (prefSBSize != null) {
            sumColWidths += prefSBSize.width;
        }
        if (thead.getWidth() > sumColWidths) {
            col = cModel.getColumn(2);
            col.setMinWidth(0);
            col.setPreferredWidth(thead.getWidth() - sumColWidths);
        }
    }

    @Override
    public void setActiveColors() {
        if (this.getCurrentDirectory() != null) {
            super.setActiveColors();
        } else {
            super.setInactiveColors();
        }
    }

    @Override
    public void setCurrentDirectory(DirectoryObject currentDirectory) {
        super.setCurrentDirectory(currentDirectory);
        this.newObjSelComboBox.setEnabled(currentDirectory != null);
        this.newObjButton.setEnabled(currentDirectory != null);
        this.propertiesButton.setEnabled(false);
        this.pasteButton.setEnabled(this.getFrame().canPaste());
        this.delButton.setEnabled(false);
        this.orderByFileNameButton.setEnabled(currentDirectory != null && currentDirectory.getFileCount() > 1);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        this.refresh();
        this.m_previewManager.setCurrentDirectory(currentDirectory);
    }

    public void addNewFSObject(AbstractFSObject fsObj) {
        this.m_fileTableModel.addFSObject(fsObj, fsObj instanceof DirectoryObject ? -1 : this.listTable.getSelectedRow());
        this.setCurrentFSObject(fsObj);
        this.selectCurrentFiles(false, null);
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void refresh() {
        DirectoryObject currentDirectory = this.getCurrentDirectory();
        this.m_fileTableModel.setCurrentDir(currentDirectory);
        if (currentDirectory == null) {
            this.setInactiveColors();
            this.setTitle(CONTENTS_PANE_TITLE);
            this.pasteButton.setEnabled(false);
            return;
        }
        this.setActiveColors();
        this.pasteButton.setEnabled(this.getFrame().canPaste());
        String str = currentDirectory.getParent() == null ? "Contents of series \"" : "Contents of group \"";
        String title = currentDirectory.getTitlePlain();
        String dirName = currentDirectory.getFileName();
        str = str + title + "\"";
        if (title != null && !title.equals(dirName)) {
            str = str + " - Directory \"" + dirName + "\"";
        }
        this.setTitle(str);
    }

    @Override
    public void onTitleSelectionChanged(int panelId) {
        this.m_bIsPreviewShowing = panelId == 1;
        this.m_previewManager.setActive(this.m_bIsPreviewShowing);
    }

    public void selectCurrentFiles(boolean bRefresh, List<AbstractFSObject> fileObjs) {
        if (this.listTable.getRowCount() == 0) {
            return;
        }
        if (fileObjs == null) {
            fileObjs = new ArrayList<AbstractFSObject>(40);
            if (this.getCurrentFSObjects() != null) {
                fileObjs.addAll(this.getCurrentFSObjects());
            }
        }
        if (bRefresh) {
            this.m_fileTableModel.refresh();
        }
        int firstIndex = -1;
        this.listTable.clearSelection();
        if (fileObjs.size() >= 1) {
            for (AbstractFSObject fsObj : fileObjs) {
                int index = this.m_fileTableModel.getIndexOfFSObject(fsObj);
                if (index < 0) continue;
                this.listTable.addRowSelectionInterval(index, index);
                if (firstIndex >= 0) continue;
                firstIndex = index;
            }
        } else {
            firstIndex = 0;
            this.listTable.setRowSelectionInterval(firstIndex, firstIndex);
        }
        if (firstIndex >= 0) {
            // empty if block
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        DirectoryObject currentDir = this.getCurrentDirectory();
        this.newObjSelComboBox.setEnabled(currentDir != null);
        this.newObjButton.setEnabled(currentDir != null);
        this.delButton.setEnabled(false);
        this.setCurrentFSObjects(null);
        if (currentDir == null) {
            return;
        }
        int[] selRows = this.listTable.getSelectedRows();
        if (selRows.length == 0) {
            return;
        }
        ArrayList<AbstractFSObject> currentFSObjs = new ArrayList<AbstractFSObject>();
        for (int i = 0; i < selRows.length; ++i) {
            currentFSObjs.add(this.m_fileTableModel.getFSObjectAt(selRows[i]));
        }
        this.setCurrentFSObjects(currentFSObjs);
        this.delButton.setEnabled(true);
        if (currentFSObjs.size() == 1) {
            boolean bIsSeparator = false;
            if (currentFSObjs.get(0) instanceof FileObject && ((FileObject)currentFSObjs.get(0)).isSeparator()) {
                bIsSeparator = true;
            }
            this.propertiesButton.setEnabled(!bIsSeparator);
        } else {
            this.propertiesButton.setEnabled(false);
        }
        boolean bCanMoveDown = true;
        boolean bCanMoveUp = true;
        for (AbstractFSObject fsObj : currentFSObjs) {
            if (!currentDir.canMoveUp(fsObj)) {
                bCanMoveUp = false;
            }
            if (currentDir.canMoveDown(fsObj)) continue;
            bCanMoveDown = false;
        }
        this.moveUpButton.setEnabled(bCanMoveUp);
        this.moveDownButton.setEnabled(bCanMoveDown);
        this.fireSelectionChanged(currentFSObjs);
    }

    public List<AbstractFSObject> getSelectedFiles() {
        if (this.getCurrentFSObjects() == null) {
            return new ArrayList<AbstractFSObject>();
        }
        ArrayList<AbstractFSObject> fileObjs = new ArrayList<AbstractFSObject>(this.getCurrentFSObjects().size());
        fileObjs.addAll(this.getCurrentFSObjects());
        return fileObjs;
    }

    public AbstractFSObject getPreviousFile() {
        int index = this.listTable.getSelectedRow();
        if (index >= 0) {
            AbstractFSObject fsObj = this.m_fileTableModel.getFSObjectAt(index);
            if (fsObj == null && index >= 1) {
                fsObj = this.m_fileTableModel.getFSObjectAt(index - 1);
            }
            if (fsObj != null) {
                return fsObj;
            }
        }
        return null;
    }

    public void removeFSObject(AbstractFSObject fsObj) {
        this.m_fileTableModel.removeFSObject(fsObj);
    }

    public void showFileContextMenu(int x, int y) {
        int rowIndex;
        DirectoryObject currentDir = this.getCurrentDirectory();
        List<AbstractFSObject> currentFSObjs = this.getCurrentFSObjects();
        if ((currentFSObjs == null || currentFSObjs.size() <= 1) && (rowIndex = this.listTable.rowAtPoint(new Point(x, y))) >= 0) {
            this.listTable.setRowSelectionInterval(rowIndex, rowIndex);
            currentFSObjs = this.getCurrentFSObjects();
        }
        if (currentDir == null || currentFSObjs == null || currentFSObjs.size() == 0) {
            return;
        }
        if (this.m_filePopupMenu == null) {
            this.m_filePopupMenu = new JPopupMenu("File Menu");
            this.m_fpProperties = new JMenuItem("Properties");
            this.m_fpProperties.addActionListener(this);
            this.m_fpOpen = new JMenuItem("Open");
            this.m_fpOpen.addActionListener(this);
            this.m_fpShowExported = new JMenuItem("Show Exported");
            this.m_fpShowExported.addActionListener(this);
            this.m_fpAssociate = new JMenuItem("Set File ...");
            this.m_fpAssociate.addActionListener(this);
            this.m_fpCut = new JMenuItem("Cut");
            this.m_fpCut.addActionListener(this);
            this.m_fpDelete = new JMenuItem("Delete");
            this.m_fpDelete.addActionListener(this);
            this.m_fpMoveUp = new JMenuItem("Move Up");
            this.m_fpMoveUp.addActionListener(this);
            this.m_fpMoveDown = new JMenuItem("Move Down");
            this.m_fpMoveDown.addActionListener(this);
            this.m_filePopupMenu.add(this.m_fpProperties);
            this.m_filePopupMenu.add(this.m_fpOpen);
            this.m_filePopupMenu.add(this.m_fpShowExported);
            JSeparator sep = new JSeparator();
            sep.setBackground(new Color(255, 255, 255));
            sep.setForeground(new Color(153, 153, 153));
            this.m_filePopupMenu.add(sep);
            this.m_filePopupMenu.add(this.m_fpAssociate);
            sep = new JSeparator();
            sep.setBackground(new Color(255, 255, 255));
            sep.setForeground(new Color(153, 153, 153));
            this.m_filePopupMenu.add(sep);
            this.m_filePopupMenu.add(this.m_fpCut);
            this.m_filePopupMenu.add(this.m_fpDelete);
            sep = new JSeparator();
            sep.setBackground(new Color(255, 255, 255));
            sep.setForeground(new Color(153, 153, 153));
            this.m_filePopupMenu.add(sep);
            this.m_filePopupMenu.add(this.m_fpMoveUp);
            this.m_filePopupMenu.add(this.m_fpMoveDown);
        }
        Font fn = this.m_fpOpen.getFont();
        if (currentFSObjs.size() == 1) {
            if (currentFSObjs.get(0) instanceof DirectoryObject && this.m_bDblClickOnDirOpens || currentFSObjs.get(0) instanceof FileObject && this.m_bDblClickOnFileOpens) {
                this.m_fpProperties.setFont(fn.deriveFont(0));
                this.m_fpOpen.setFont(fn.deriveFont(1));
            } else {
                this.m_fpProperties.setFont(fn.deriveFont(1));
                this.m_fpOpen.setFont(fn.deriveFont(0));
            }
        } else {
            this.m_fpProperties.setFont(fn.deriveFont(0));
            this.m_fpOpen.setFont(fn.deriveFont(0));
        }
        boolean bHaveSeparator = false;
        boolean bHaveReference = false;
        boolean bIsExported = false;
        boolean bCanMoveDown = true;
        boolean bCanMoveUp = true;
        for (AbstractFSObject fsObj : currentFSObjs) {
            if (fsObj instanceof FileObject) {
                FileObject fileObj = (FileObject)fsObj;
                if (fileObj.isSeparator()) {
                    bHaveSeparator = true;
                }
                if (fileObj.getFileType() == 1 && fileObj.isToExport()) {
                    bIsExported = true;
                }
            }
            if (fsObj.isReference()) {
                bHaveReference = true;
            }
            if (!currentDir.canMoveUp(fsObj)) {
                bCanMoveUp = false;
            }
            if (currentDir.canMoveDown(fsObj)) continue;
            bCanMoveDown = false;
        }
        if (currentFSObjs.size() == 1) {
            this.m_fpOpen.setEnabled(!bHaveReference);
            this.m_fpShowExported.setEnabled(bIsExported);
            this.m_fpProperties.setEnabled(!bHaveSeparator);
            this.m_fpAssociate.setEnabled(bHaveReference && !bHaveSeparator);
        } else {
            this.m_fpOpen.setEnabled(false);
            this.m_fpShowExported.setEnabled(false);
            this.m_fpProperties.setEnabled(false);
            this.m_fpAssociate.setEnabled(false);
        }
        this.m_fpCut.setEnabled(!bHaveSeparator);
        this.m_fpMoveUp.setEnabled(bCanMoveUp);
        this.m_fpMoveDown.setEnabled(bCanMoveDown);
        this.m_filePopupMenu.show(this.listTable, x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object evtSource = e.getSource();
        List<AbstractFSObject> m_currentFileObjs = this.getCurrentFSObjects();
        if (evtSource == this.m_fpProperties) {
            this.propertiesButtonActionPerformed(e);
        } else if (evtSource == this.m_fpDelete) {
            this.delButtonActionPerformed(e);
        } else if (evtSource == this.m_fpMoveUp) {
            this.moveUpButtonActionPerformed(e);
        } else if (evtSource == this.m_fpMoveDown) {
            this.moveDownButtonActionPerformed(e);
        } else if (evtSource == this.m_fpOpen) {
            if (m_currentFileObjs.size() == 1) {
                if (m_currentFileObjs.get(0) instanceof DirectoryObject) {
                    DirectoryObject dirObj = (DirectoryObject)m_currentFileObjs.get(0);
                    this.setCurrentDirectory(dirObj);
                    this.fireCurrentDirectoryChanged(dirObj);
                } else {
                    ShellExec exec = new ShellExec(this.getFrame());
                    exec.openDocument((FileObject)m_currentFileObjs.get(0));
                }
            }
        } else if (evtSource == this.m_fpShowExported) {
            if (m_currentFileObjs.size() == 1 && m_currentFileObjs.get(0) instanceof FileObject) {
                ExportedImageViewDialog dlg = new ExportedImageViewDialog((FileObject)m_currentFileObjs.get(0), this.getFrame().getSettings(), this.getFrame().getSeriesContainer(), this.getFrame(), true);
                dlg.setVisible(true);
            }
        } else if (evtSource == this.m_fpCut) {
            this.getFrame().cut(m_currentFileObjs);
            this.pasteButton.setEnabled(this.getFrame().canPaste());
        } else if (evtSource == this.m_fpAssociate) {
            if (m_currentFileObjs.size() != 1 || !(m_currentFileObjs.get(0) instanceof FileObject)) {
                return;
            }
            AssociateDialog dia = new AssociateDialog((Frame)this.getFrame(), this.getFrame().getImageHolder(), (FileObject)m_currentFileObjs.get(0), true);
            if (!dia.showDialog()) {
                return;
            }
            this.selectCurrentFiles(true, null);
        }
    }

    public void renameExportedFiles(AbstractFSObject oldFsObj, DirectoryObject newParent, String newName) {
        this.getFrame().renameExportedFiles(oldFsObj, newParent, newName);
    }

    public void onDoubleClickListTable() {
        List<AbstractFSObject> m_currentFileObjs = this.getCurrentFSObjects();
        if (m_currentFileObjs.size() != 1) {
            return;
        }
        AbstractFSObject currentFSObj = m_currentFileObjs.get(0);
        if (currentFSObj instanceof FileObject && ((FileObject)currentFSObj).isSeparator()) {
            return;
        }
        if (this.m_bDblClickOnDirOpens && currentFSObj instanceof DirectoryObject) {
            DirectoryObject dirObj = (DirectoryObject)currentFSObj;
            this.setCurrentDirectory(dirObj);
            this.fireCurrentDirectoryChanged(dirObj);
            return;
        }
        if (this.m_bDblClickOnFileOpens && currentFSObj instanceof FileObject) {
            ShellExec exec = new ShellExec(this.getFrame());
            exec.openDocument((FileObject)currentFSObj);
            return;
        }
        this.propertiesButtonActionPerformed(null);
    }

    @Override
    public void loadSettings(Settings settings) {
        String valStr;
        TableColumnModel cModel = this.listTable.getColumnModel();
        int i = 1;
        while ((valStr = settings.get(CONT_COLUMN_POS + i)) != null && valStr.length() != 0) {
            StringTokenizer tok;
            TableColumn col;
            if (!valStr.startsWith("-") && (col = cModel.getColumn(i - 1)).getResizable() && (tok = new StringTokenizer(valStr, ",")).countTokens() >= 3) {
                try {
                    col.setMinWidth(Integer.parseInt(tok.nextToken()));
                    col.setMaxWidth(Integer.parseInt(tok.nextToken()));
                    col.setPreferredWidth(Integer.parseInt(tok.nextToken()));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.m_bDblClickOnDirOpens = settings.getBoolean(DBL_CLICK_DIR_OPENS, false);
        this.m_bDblClickOnFileOpens = settings.getBoolean(DBL_CLICK_FILE_OPENS, false);
        this.m_previewManager.loadSettings(settings);
        this.m_bIsPreviewShowing = settings.getBoolean(CONT_SHOW_PREVIEW, false);
        this.getTitleLabel().setPanelComponents(this.aspectsPanel, this.contentsPanel, this.previewPanel, this.m_bIsPreviewShowing);
        this.getTitleLabel().addChangeListener(this);
        this.m_previewManager.setActive(this.m_bIsPreviewShowing);
    }

    @Override
    public void saveSettings(Settings settings) {
        TableColumnModel cModel = this.listTable.getColumnModel();
        for (int i = 1; i <= cModel.getColumnCount(); ++i) {
            TableColumn col = cModel.getColumn(i - 1);
            if (!col.getResizable()) {
                settings.set(CONT_COLUMN_POS + i, "-");
                continue;
            }
            settings.set(CONT_COLUMN_POS + i, Integer.toString(col.getMinWidth()) + "," + col.getMaxWidth() + "," + col.getPreferredWidth());
        }
        settings.setBoolean(CONT_SHOW_PREVIEW, this.m_bIsPreviewShowing);
        this.m_previewManager.saveSettings(settings);
    }

    @Override
    public void focusGained(FocusEvent e) {
        List<AbstractFSObject> ls = this.getCurrentFSObjects();
        if (ls != null && !ls.isEmpty()) {
            this.fireSelectionChanged(ls);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void initComponents() {
        this.aspectsPanel = new JPanel();
        this.contentsPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.newObjPanel = new JPanel();
        this.newObjSelComboBox = new JComboBox();
        this.newObjButton = new JButton();
        this.separatorLabel = new JLabel();
        this.propertiesButton = new JButton();
        this.separatorLabel1 = new JLabel();
        this.pasteButton = new JButton();
        this.delButton = new JButton();
        this.separatorLabel2 = new JLabel();
        this.orderByFileNameButton = new JButton();
        this.separatorLabel3 = new JLabel();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.listScrollPane = new JScrollPane();
        this.listTable = new JTable();
        this.previewPanel = new JPanel();
        this.previewCenterPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.htmlPane = new JEditorPane();
        this.setLayout(new BorderLayout());
        this.aspectsPanel.setLayout(new CardLayout());
        this.contentsPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new FlowLayout(0, 5, 2));
        this.newObjPanel.setLayout(new GridBagLayout());
        this.newObjSelComboBox.setToolTipText("Choose the kind of object to be created and press the \"New\" button");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.newObjPanel.add((Component)this.newObjSelComboBox, gridBagConstraints);
        this.newObjButton.setText("New");
        this.newObjButton.setToolTipText("Creates an object of the kind selected in the combo box");
        this.newObjButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentsPanel.this.newObjButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.newObjPanel.add((Component)this.newObjButton, gridBagConstraints);
        this.buttonPanel.add(this.newObjPanel);
        this.separatorLabel.setText(" ");
        this.separatorLabel.setMaximumSize(new Dimension(5, 14));
        this.separatorLabel.setMinimumSize(new Dimension(5, 14));
        this.separatorLabel.setPreferredSize(new Dimension(5, 14));
        this.buttonPanel.add(this.separatorLabel);
        this.propertiesButton.setText("Properties");
        this.propertiesButton.setToolTipText("Displays the properties of the selected file or subgroup");
        this.propertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentsPanel.this.propertiesButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.propertiesButton);
        this.separatorLabel1.setText(" ");
        this.separatorLabel1.setMaximumSize(new Dimension(5, 14));
        this.separatorLabel1.setMinimumSize(new Dimension(5, 14));
        this.separatorLabel1.setPreferredSize(new Dimension(5, 14));
        this.buttonPanel.add(this.separatorLabel1);
        this.pasteButton.setText("Paste");
        this.pasteButton.setToolTipText("Pasts the cut file or directory into this directory");
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentsPanel.this.pasteButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.pasteButton);
        this.delButton.setText("Delete");
        this.delButton.setToolTipText("Deletes the selected file or subgroup");
        this.delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentsPanel.this.delButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.delButton);
        this.separatorLabel2.setText(" ");
        this.separatorLabel2.setMaximumSize(new Dimension(5, 14));
        this.separatorLabel2.setMinimumSize(new Dimension(5, 14));
        this.separatorLabel2.setPreferredSize(new Dimension(5, 14));
        this.buttonPanel.add(this.separatorLabel2);
        this.orderByFileNameButton.setText("Order by File Name");
        this.orderByFileNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentsPanel.this.orderByFileNameButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.orderByFileNameButton);
        this.separatorLabel3.setText(" ");
        this.separatorLabel3.setMaximumSize(new Dimension(5, 14));
        this.separatorLabel3.setMinimumSize(new Dimension(5, 14));
        this.separatorLabel3.setPreferredSize(new Dimension(5, 14));
        this.buttonPanel.add(this.separatorLabel3);
        this.moveUpButton.setText("Move Up");
        this.moveUpButton.setToolTipText("Moves up the selected file or subgroup");
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentsPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.moveUpButton);
        this.moveDownButton.setText("Move Down");
        this.moveDownButton.setToolTipText("Moves down the selected file or subgroup");
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentsPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.moveDownButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.contentsPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.listTable.setModel(this.m_fileTableModel);
        this.listTable.setShowHorizontalLines(false);
        this.listTable.setShowVerticalLines(false);
        this.listScrollPane.setViewportView(this.listTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.contentsPanel.add((Component)this.listScrollPane, gridBagConstraints);
        this.aspectsPanel.add((Component)this.contentsPanel, "normal");
        this.previewPanel.setLayout(new GridBagLayout());
        this.previewCenterPanel.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.htmlPane);
        this.previewCenterPanel.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.previewPanel.add((Component)this.previewCenterPanel, gridBagConstraints);
        this.aspectsPanel.add((Component)this.previewPanel, "preview");
        this.add((Component)this.aspectsPanel, "Center");
    }

    private void newObjButtonActionPerformed(ActionEvent evt) {
        DirectoryObject currentDir = this.getCurrentDirectory();
        if (currentDir == null) {
            return;
        }
        String selObjType = (String)this.newObjSelComboBox.getSelectedItem();
        if (selObjType.equals(NEWITEM_FILE)) {
            this.getFrame().newFile(currentDir);
        } else if (selObjType.equals(NEWITEM_SUBGROUP)) {
            this.getFrame().newDirectory(currentDir);
        } else if (selObjType.equals(NEWITEM_REFERENCE)) {
            FileObject fe = new FileObject("", currentDir);
            fe.setReference(true);
            this.getFrame().finishFileObj(fe);
        } else if (selObjType.equals(NEWITEM_SEPARATOR)) {
            FileObject fe = new FileObject("", currentDir);
            fe.makeSeparator();
            this.getFrame().finishFileObj(fe);
        }
    }

    private void propertiesButtonActionPerformed(ActionEvent evt) {
        List<AbstractFSObject> m_currentFileObjs = this.getCurrentFSObjects();
        if (m_currentFileObjs == null || m_currentFileObjs.size() != 1) {
            return;
        }
        AbstractFSObject fsObj = m_currentFileObjs.get(0);
        boolean oldToExport = fsObj.isToExport();
        int oldQuality = fsObj.getConversionQuality();
        File[] exFiles = ExportFactory.getExport(this.getFrame().getSettings(), this.getFrame().getSeriesContainer(), this).getExportedFiles(fsObj);
        PropertiesDialog dlg = new PropertiesDialog(this.getFrame().getImageHolder(), fsObj, exFiles, this.getFrame(), true);
        if (dlg.showDialog()) {
            if (fsObj instanceof FileObject && !fsObj.isToExport()) {
                try {
                    ExportFactory.getExport(this.getFrame().getSettings(), this.getFrame().getSeriesContainer(), this).deleteExportedFiles(fsObj, 1);
                }
                catch (ExportException ignored) {}
            } else if (fsObj instanceof FileObject && (!oldToExport && fsObj.isToExport() || oldQuality != fsObj.getConversionQuality())) {
                this.getFrame().startExport(fsObj, true, true, true);
            }
            this.selectCurrentFiles(true, null);
            this.firePropertiesChanged(fsObj);
        }
    }

    private void pasteButtonActionPerformed(ActionEvent evt) {
        this.getFrame().paste();
        this.pasteButton.setEnabled(false);
    }

    private void delButtonActionPerformed(ActionEvent evt) {
        this.getFrame().delete(this.getCurrentFSObjects());
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        DirectoryObject currentDir = this.getCurrentDirectory();
        List<AbstractFSObject> currentFileObjs = this.getCurrentFSObjects();
        boolean bHaveDirs = false;
        if (currentDir == null || currentFileObjs.size() == 0) {
            return;
        }
        for (AbstractFSObject fsObj : currentFileObjs) {
            if (fsObj instanceof DirectoryObject) {
                bHaveDirs = true;
                currentDir.moveSubDirUp((DirectoryObject)fsObj);
                continue;
            }
            if (!(fsObj instanceof FileObject)) continue;
            currentDir.moveFileUp((FileObject)fsObj);
        }
        if (bHaveDirs) {
            this.firePropertiesChanged(currentDir);
        }
        this.selectCurrentFiles(true, null);
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        DirectoryObject currentDir = this.getCurrentDirectory();
        List<AbstractFSObject> currentFileObjs = this.getCurrentFSObjects();
        boolean bHaveDirs = false;
        if (currentDir == null || currentFileObjs.size() == 0) {
            return;
        }
        for (int i = currentFileObjs.size() - 1; i >= 0; --i) {
            AbstractFSObject fsObj = currentFileObjs.get(i);
            if (fsObj instanceof DirectoryObject) {
                bHaveDirs = true;
                currentDir.moveSubDirDown((DirectoryObject)fsObj);
                continue;
            }
            if (!(fsObj instanceof FileObject)) continue;
            currentDir.moveFileDown((FileObject)fsObj);
        }
        if (bHaveDirs) {
            this.firePropertiesChanged(currentDir);
        }
        this.selectCurrentFiles(true, null);
    }

    private void orderByFileNameButtonActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Permanently reorder the files by name?", "JPhoto-Explorer", 0) != 0) {
            return;
        }
        DirectoryObject currentDir = this.getCurrentDirectory();
        if (currentDir == null) {
            return;
        }
        currentDir.orderFilesByFileName();
        this.firePropertiesChanged(currentDir);
        this.selectCurrentFiles(true, null);
    }
}

