/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.panel;

import com.dgrossmann.photo.ui.ImageHolder;
import com.dgrossmann.photo.ui.panel.PanelTitleChangeListener;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelTitleComponent
extends JPanel {
    private static final String PREVIEW_TOOL_TIP = "Show the preview panel";
    private static final String PREVIEW_SEL_TOOL_TIP = "Hide the preview panel";
    public static final Color COL_FOREGROUND = Color.WHITE;
    public static final Color COL_ACTIVE_BLUE_LIGHT = new Color(133, 166, 255);
    public static final Color COL_ACTIVE_BLUE_DARK = new Color(44, 66, 222);
    public static final Color COL_ACTIVE_RED_LIGHT = new Color(222, 155, 177);
    public static final Color COL_ACTIVE_RED_DARK = new Color(211, 44, 88);
    public static final Color COL_INACTIVE_RED_LIGHT = new Color(202, 188, 177);
    public static final Color COL_INACTIVE_BLUE_LIGHT = new Color(185, 185, 192);
    public static final Color COL_INACTIVE_DARK = new Color(166, 155, 144);
    public static final Color COL_BOTTOM_LINE = new Color(133, 133, 133);
    public static final int ACTIVE_BG_LEFT_COLOR = 1;
    public static final int ACTIVE_BG_MIDDLE_COLOR = 2;
    public static final int INACTIVE_BG_LEFT_COLOR = 3;
    public static final int INACTIVE_BG_MIDDLE_COLOR = 4;
    public static final int ACTIVE_BOTTOM_LINE_COLOR = 5;
    public static final int INACTIVE_BOTTOM_LINE_COLOR = 6;
    public static final String CARD_NORMAL = "normal";
    public static final String CARD_PREVIEW = "preview";
    private static ImageIcon s_previewIcon = null;
    private static ImageIcon s_previewSelIcon = null;
    private boolean m_bIsActive;
    private Icon m_titleImage;
    private String m_title;
    private boolean m_bIsPreviewSelected = false;
    private JPanel m_parentPanel;
    private JPanel m_normalPanel;
    private JPanel m_previewPanel;
    private PanelTitleChangeListener m_changeListener;
    private Color m_fgColor;
    private Color m_stdFgColor;
    private Color m_topBgColor;
    private Color m_middleBgColor;
    private Color m_stdActiveTopBgColor;
    private Color m_stdInactiveTopBgColor;
    private Color m_stdActiveMiddleBgColor;
    private Color m_stdInactiveMiddleBgColor;
    private Color m_bottomLineColor;
    private Color m_stdActiveBottomLineColor;
    private Color m_stdInactiveBottomLineColor;
    private boolean m_bSimpleGradient;
    private boolean m_bHasPainted = false;
    private JLabel previewCtrl;
    private JLabel titleLabel;

    public PanelTitleComponent() {
        this(" ", null);
    }

    public PanelTitleComponent(String title) {
        this(title, null);
    }

    public PanelTitleComponent(String title, Icon image) {
        this.m_titleImage = image;
        this.m_title = title;
        if (this.m_title == null || this.m_title.length() == 0) {
            this.m_title = " ";
        }
        this.m_previewPanel = null;
        this.m_normalPanel = null;
        this.m_parentPanel = null;
        this.m_changeListener = null;
        this.initComponents();
        if (s_previewIcon == null) {
            s_previewIcon = ImageHolder.loadStandardImage("images/preview.gif", this);
            s_previewSelIcon = ImageHolder.loadStandardImage("images/preview_sel.gif", this);
        }
        this.titleLabel.setText(this.m_title);
        boolean bRedColors = false;
        if (!"Windows XP".equalsIgnoreCase(System.getProperty("os.name"))) {
            bRedColors = SystemColor.activeCaption.getRed() > SystemColor.activeCaption.getBlue();
        }
        this.m_stdFgColor = COL_FOREGROUND;
        if (bRedColors) {
            this.setRedStandardColors();
        } else {
            this.setBlueStandardColors();
        }
        this.m_stdInactiveTopBgColor = COL_INACTIVE_DARK;
        this.m_stdActiveBottomLineColor = COL_BOTTOM_LINE;
        this.m_stdInactiveBottomLineColor = COL_BOTTOM_LINE;
        this.m_bIsActive = true;
        this.setActiveColors();
        this.setCaneGradient(false);
        Font fn = this.titleLabel.getFont();
        Font newFont = fn.deriveFont(1);
        this.titleLabel.setFont(newFont);
        this.titleLabel.setForeground(this.m_fgColor);
        this.titleLabel.setOpaque(false);
    }

    public void setPanelComponents(JPanel parentPanel, JPanel normalPanel, JPanel previewPanel, boolean bSelectPreviewPanel) {
        this.m_parentPanel = parentPanel;
        this.m_normalPanel = normalPanel;
        this.m_previewPanel = previewPanel;
        this.setPreview(bSelectPreviewPanel);
    }

    public void setText(String title) {
        this.m_title = title == null || title.length() == 0 ? " " : title;
        this.titleLabel.setText(this.m_title);
    }

    public boolean isPreview() {
        return this.m_bIsPreviewSelected;
    }

    public void setPreview(boolean bIsPreview) {
        if (this.m_parentPanel == null) {
            return;
        }
        this.m_bIsPreviewSelected = bIsPreview;
        this.previewCtrl.setIcon(this.m_bIsPreviewSelected ? s_previewSelIcon : s_previewIcon);
        this.previewCtrl.setToolTipText(this.m_bIsPreviewSelected ? PREVIEW_SEL_TOOL_TIP : PREVIEW_TOOL_TIP);
        if (this.m_bIsPreviewSelected) {
            ((CardLayout)this.m_parentPanel.getLayout()).show(this.m_previewPanel.getParent(), CARD_PREVIEW);
        } else {
            ((CardLayout)this.m_parentPanel.getLayout()).show(this.m_previewPanel.getParent(), CARD_NORMAL);
        }
    }

    public void addChangeListener(PanelTitleChangeListener changeListener) {
        this.m_changeListener = changeListener;
    }

    public void setActiveColors() {
        this.m_bIsActive = true;
        this.m_fgColor = this.m_stdFgColor;
        this.m_topBgColor = this.m_stdActiveTopBgColor;
        this.m_middleBgColor = this.m_stdActiveMiddleBgColor;
        this.m_bottomLineColor = this.m_stdActiveBottomLineColor;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setInactiveColors() {
        this.m_bIsActive = false;
        this.m_fgColor = this.m_stdFgColor;
        this.m_topBgColor = this.m_stdInactiveTopBgColor;
        this.m_middleBgColor = this.m_stdInactiveMiddleBgColor;
        this.m_bottomLineColor = this.m_stdInactiveBottomLineColor;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public Color getBrighterColor(Color color) {
        int avgVal = (color.getRed() + color.getGreen() + color.getBlue()) / 3;
        Color col = color.brighter();
        if (avgVal < 200) {
            col = col.brighter();
        }
        return col;
    }

    public void setCaneGradient(boolean bCane) {
        boolean bl = this.m_bSimpleGradient = !bCane;
        if (this.m_bHasPainted) {
            Dimension siz = this.getSize();
            if (siz.width > 0 && siz.height > 0) {
                this.repaint(new Rectangle(siz));
            }
        }
    }

    public void setBackground(int whichColor, Color newColor) {
        if (newColor == null) {
            return;
        }
        switch (whichColor) {
            case 1: {
                this.m_stdActiveTopBgColor = newColor;
                break;
            }
            case 2: {
                if (newColor == null) break;
                this.m_stdActiveMiddleBgColor = newColor;
                break;
            }
            case 5: {
                this.m_stdActiveBottomLineColor = newColor;
                break;
            }
            case 3: {
                this.m_stdInactiveTopBgColor = newColor;
                break;
            }
            case 4: {
                if (newColor == null) break;
                this.m_stdInactiveMiddleBgColor = newColor;
                break;
            }
            case 6: {
                this.m_stdInactiveBottomLineColor = newColor;
            }
        }
        if (this.m_bHasPainted) {
            Dimension siz = this.getSize();
            if (siz.width > 0 && siz.height > 0) {
                this.repaint(new Rectangle(siz));
            }
        }
    }

    public void setRedStandardColors() {
        this.m_stdActiveTopBgColor = COL_ACTIVE_RED_DARK;
        this.m_stdActiveMiddleBgColor = COL_ACTIVE_RED_LIGHT;
        this.m_stdInactiveMiddleBgColor = COL_INACTIVE_RED_LIGHT;
        if (this.m_bHasPainted) {
            Dimension siz = this.getSize();
            if (siz.width > 0 && siz.height > 0) {
                this.repaint(new Rectangle(siz));
            }
        }
    }

    public void setBlueStandardColors() {
        this.m_stdActiveTopBgColor = COL_ACTIVE_BLUE_DARK;
        this.m_stdActiveMiddleBgColor = COL_ACTIVE_BLUE_LIGHT;
        this.m_stdInactiveMiddleBgColor = COL_INACTIVE_BLUE_LIGHT;
        if (this.m_bHasPainted) {
            Dimension siz = this.getSize();
            if (siz.width > 0 && siz.height > 0) {
                this.repaint(new Rectangle(siz));
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Dimension siz = this.getSize();
        if (siz.width > 0 && siz.height > 0) {
            float middleY = siz.height / 2 - 2;
            float bottomY = siz.height - 3;
            Paint oldPaint = g2d.getPaint();
            if (this.m_bSimpleGradient) {
                GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.m_middleBgColor, 0.0f, bottomY, this.m_topBgColor);
                g2d.setPaint(paint);
                g2d.fillRect(0, 0, siz.width, siz.height - 1);
            } else {
                int middleYint = (int)middleY;
                GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.m_topBgColor, 0.0f, middleY, this.m_middleBgColor);
                g2d.setPaint(paint);
                g2d.fillRect(0, 0, siz.width, middleYint);
                paint = new GradientPaint(0.0f, middleY, this.m_middleBgColor, 0.0f, bottomY, this.m_topBgColor);
                g2d.setPaint(paint);
                g2d.fillRect(0, middleYint, siz.width, siz.height - 2);
            }
            g2d.setPaint(oldPaint);
            if (this.m_bottomLineColor != null) {
                Color oldColor = g2d.getColor();
                g2d.setColor(this.m_bottomLineColor);
                g2d.drawLine(0, siz.height - 1, siz.width - 1, siz.height - 1);
                g2d.setColor(oldColor);
            }
            this.m_bHasPainted = true;
        }
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.previewCtrl = new JLabel();
        this.setLayout(new GridBagLayout());
        this.titleLabel.setText("Title");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.titleLabel, gridBagConstraints);
        this.previewCtrl.setMaximumSize(new Dimension(60, 16));
        this.previewCtrl.setMinimumSize(new Dimension(60, 16));
        this.previewCtrl.setPreferredSize(new Dimension(60, 16));
        this.previewCtrl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PanelTitleComponent.this.onPreviewCtrlClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.previewCtrl, gridBagConstraints);
    }

    private void onPreviewCtrlClicked(MouseEvent evt) {
        if (this.m_parentPanel == null) {
            return;
        }
        this.setPreview(!this.m_bIsPreviewSelected);
        if (this.m_changeListener != null) {
            this.m_changeListener.onTitleSelectionChanged(this.m_bIsPreviewSelected ? 1 : 0);
        }
    }
}

