/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.panel;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.persist.PersistException;
import com.dgrossmann.photo.settings.Settings;
import com.dgrossmann.photo.ui.ExplorerMainFrame;
import com.dgrossmann.photo.ui.panel.AbstractExplorerPanel;
import com.dgrossmann.photo.ui.panel.DirTreeModel;
import com.dgrossmann.photo.ui.panel.DirTreeMouseListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DirTreePanel
extends AbstractExplorerPanel
implements TreeSelectionListener,
TreeExpansionListener,
ActionListener,
FocusListener {
    public static final String SAVE_CURRENT_DIR_ON_EXIT = "dirtree.save_current_dir_on_exit";
    public static final String CURRENT_DIR = "dirtree.current_dir";
    private static final String DIR_PANE_TITLE = "Series";
    private JTree m_dirTree;
    private DirTreeModel m_dirTreeModel;
    private boolean m_bSaveCurrentDirOnExit = false;
    private JPopupMenu m_dirPopupMenu = null;
    private JMenuItem m_dpNewDir;
    private JMenuItem m_dpPaste;
    private JMenuItem m_dpProperties;
    private JMenuItem m_dpCut;
    private JMenuItem m_dpDelete;
    private JMenuItem m_dpExport;

    public DirTreePanel(ExplorerMainFrame frm) {
        super(frm, DIR_PANE_TITLE);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTitleLabel(), "North");
        this.m_dirTreeModel = new DirTreeModel(this.getFrame().getSeriesContainer(), this.getFrame());
        this.m_dirTree = new JTree(this.m_dirTreeModel);
        this.m_dirTree.setVisibleRowCount(80);
        this.m_dirTree.setEditable(true);
        this.m_dirTree.putClientProperty("JTree.lineStyle", "Angled");
        this.m_dirTree.getSelectionModel().setSelectionMode(1);
        this.m_dirTree.addTreeSelectionListener(this);
        this.m_dirTree.addTreeExpansionListener(this);
        this.m_dirTree.addMouseListener(new DirTreeMouseListener(this));
        this.m_dirTree.addFocusListener(this);
        this.add((Component)new JScrollPane(this.m_dirTree, 20, 30), "Center");
        if (this.m_dirTree.getRowCount() > 0) {
            this.m_dirTree.expandRow(0);
            this.m_dirTree.setSelectionRow(0);
        }
    }

    @Override
    public void setupComponents() {
    }

    @Override
    public void setCurrentDirectory(DirectoryObject currentDirectory) {
        DirectoryObject oldDir = this.getCurrentDirectory();
        super.setCurrentDirectory(currentDirectory);
        if (oldDir.getIndexOfSubDir(currentDirectory) >= 0) {
            TreePath selPath = this.m_dirTree.getSelectionPath();
            this.m_dirTree.expandPath(selPath);
            Object[] oldPath = selPath.getPath();
            Object[] newPath = new Object[oldPath.length + 1];
            for (int i = 0; i < oldPath.length; ++i) {
                newPath[i] = oldPath[i];
            }
            newPath[i] = currentDirectory;
            this.m_dirTree.setSelectionPath(new TreePath(newPath));
            return;
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        Object node = event.getPath().getLastPathComponent();
        if (node == null || !(node instanceof DirectoryObject)) {
            return;
        }
        DirectoryObject dir = (DirectoryObject)node;
        if (dir.getParent() == null) {
            this.setCursor(new Cursor(3));
            this.getFrame().getSeriesContainer().ensureLoaded(dir);
            this.m_dirTreeModel.fireTreeStructureChanged(dir);
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.getFrame().save();
        Object node = this.m_dirTree.getLastSelectedPathComponent();
        if (node == null || !(node instanceof DirectoryObject)) {
            super.setCurrentDirectory(null);
            this.fireCurrentDirectoryChanged(null);
        } else {
            DirectoryObject currentDir = (DirectoryObject)node;
            super.setCurrentDirectory(currentDir);
            if (currentDir.getParent() == null) {
                this.setCursor(new Cursor(3));
                this.getFrame().getSeriesContainer().ensureLoaded(currentDir);
                this.setCursor(new Cursor(0));
            }
            this.fireCurrentDirectoryChanged(currentDir);
        }
    }

    public DirectoryObject selectDirForPath(TreePath treePath, boolean bExact) {
        if (treePath == null || this.m_dirTree == null || this.m_dirTree.getRowCount() == 0) {
            return null;
        }
        return this.selectDirForPathInternal(treePath.getPath(), bExact);
    }

    private DirectoryObject selectDirForPathInternal(Object[] objPath, boolean bExact) {
        int i;
        if (objPath == null || objPath.length < 2) {
            return null;
        }
        DirectoryObject dirObj = null;
        ArrayList<Object> newPathList = new ArrayList<Object>(objPath.length);
        newPathList.add(this.m_dirTreeModel.getRoot());
        this.m_dirTree.expandRow(0);
        DirectoryObject[] seriesDirs = this.getFrame().getSeriesContainer().getSeriesDirectories();
        String str = objPath[1].toString();
        for (i = 0; i < seriesDirs.length; ++i) {
            if (!seriesDirs[i].getFileName().equalsIgnoreCase(str)) continue;
            dirObj = seriesDirs[i];
            newPathList.add(seriesDirs[i]);
            break;
        }
        if (dirObj == null) {
            return null;
        }
        block1: for (i = 2; dirObj != null && i < objPath.length; ++i) {
            this.m_dirTree.expandPath(new TreePath(newPathList.toArray()));
            str = objPath[i].toString();
            Iterator<DirectoryObject> subDirIter = dirObj.getSubDirIterator();
            if (bExact) {
                dirObj = null;
            }
            while (subDirIter.hasNext()) {
                DirectoryObject d = subDirIter.next();
                if (!d.getFileName().equalsIgnoreCase(str)) continue;
                dirObj = d;
                newPathList.add(d);
                continue block1;
            }
        }
        if (dirObj != null) {
            this.m_dirTree.setSelectionPath(new TreePath(newPathList.toArray()));
        }
        return dirObj;
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void refresh() {
        this.m_dirTreeModel.refresh(this.getCurrentDirectory());
        TreePath treePath = this.m_dirTree.getSelectionPath();
        this.m_dirTreeModel.refresh(null);
        DirectoryObject selDir = this.selectDirForPath(treePath, false);
        if (selDir != null) {
            if (selDir != this.getCurrentDirectory()) {
                this.setCurrentDirectory(selDir);
                this.fireCurrentDirectoryChanged(selDir);
            }
        } else if (this.m_dirTree.getRowCount() > 0) {
            this.m_dirTree.expandRow(0);
            this.m_dirTree.setSelectionRow(0);
        }
    }

    public void refresh(DirectoryObject dirObject) {
        this.m_dirTreeModel.refresh(dirObject);
    }

    public void onTreeStructureChanged(DirectoryObject dirObject) {
        this.m_dirTreeModel.fireTreeStructureChanged(dirObject);
    }

    private void createDirContextMenu() {
        if (this.m_dirPopupMenu != null) {
            return;
        }
        this.m_dirPopupMenu = new JPopupMenu("Directory Menu");
        this.m_dpNewDir = new JMenuItem("New Subfolder ...");
        this.m_dpNewDir.addActionListener(this);
        this.m_dpProperties = new JMenuItem("Properties");
        this.m_dpProperties.addActionListener(this);
        this.m_dpExport = new JMenuItem("Export");
        this.m_dpExport.addActionListener(this);
        this.m_dpCut = new JMenuItem("Cut");
        this.m_dpCut.addActionListener(this);
        this.m_dpPaste = new JMenuItem("Paste");
        this.m_dpPaste.addActionListener(this);
        this.m_dpDelete = new JMenuItem("Delete");
        this.m_dpDelete.addActionListener(this);
        this.m_dirPopupMenu.add(this.m_dpProperties);
        JSeparator sep = new JSeparator();
        sep.setBackground(new Color(255, 255, 255));
        sep.setForeground(new Color(153, 153, 153));
        this.m_dirPopupMenu.add(sep);
        this.m_dirPopupMenu.add(this.m_dpExport);
        sep = new JSeparator();
        sep.setBackground(new Color(255, 255, 255));
        sep.setForeground(new Color(153, 153, 153));
        this.m_dirPopupMenu.add(sep);
        this.m_dirPopupMenu.add(this.m_dpNewDir);
        sep = new JSeparator();
        sep.setBackground(new Color(255, 255, 255));
        sep.setForeground(new Color(153, 153, 153));
        this.m_dirPopupMenu.add(sep);
        this.m_dirPopupMenu.add(this.m_dpCut);
        this.m_dirPopupMenu.add(this.m_dpPaste);
        sep = new JSeparator();
        sep.setBackground(new Color(255, 255, 255));
        sep.setForeground(new Color(153, 153, 153));
        this.m_dirPopupMenu.add(sep);
        this.m_dirPopupMenu.add(this.m_dpDelete);
    }

    public void showDirContextMenu(int x, int y) {
        int rowIndex = this.m_dirTree.getRowForLocation(x, y);
        if (rowIndex >= 0) {
            this.m_dirTree.setSelectionRow(rowIndex);
        }
        if (this.getCurrentDirectory() == null) {
            return;
        }
        this.createDirContextMenu();
        this.m_dpPaste.setEnabled(this.getFrame().canPaste());
        this.m_dirPopupMenu.show(this.m_dirTree, x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object evtSource = e.getSource();
        DirectoryObject currentDir = this.getCurrentDirectory();
        if (evtSource == this.m_dpProperties) {
            if (this.getFrame().showProperties(currentDir)) {
                this.m_dirTreeModel.fireTreeStructureChanged(currentDir);
                this.firePropertiesChanged(currentDir);
            }
        } else if (evtSource == this.m_dpExport) {
            if (currentDir == null) {
                return;
            }
            this.getFrame().startExport(currentDir, true, true, false);
        } else if (evtSource == this.m_dpNewDir) {
            this.getFrame().newDirectory(currentDir);
        } else if (evtSource == this.m_dpCut) {
            if (currentDir == null) {
                return;
            }
            ArrayList<AbstractFSObject> fsObjs = new ArrayList<AbstractFSObject>(1);
            fsObjs.add(this.getCurrentDirectory());
            this.getFrame().cut(fsObjs);
        } else if (evtSource == this.m_dpPaste) {
            this.getFrame().paste();
        } else if (evtSource == this.m_dpDelete) {
            if (currentDir == null) {
                return;
            }
            int res = JOptionPane.showConfirmDialog(this, "Do you really want to delete the directory \"" + currentDir.getFileName() + "\" \nand destroy its complete contents?", "J Photo-Explorer", 0, 3);
            if (res != 0) {
                return;
            }
            if (!currentDir.delete(true)) {
                try {
                    this.getFrame().getSeriesContainer().loadSeries(currentDir);
                    JOptionPane.showMessageDialog(this, "Cannot delete directory \"" + currentDir.getFileName() + "\"", "J Photo-Explorer", 2);
                }
                catch (PersistException pe) {
                    JOptionPane.showMessageDialog(this, pe.getMessage(), "J Photo-Explorer", 0);
                }
            }
            this.refresh();
            this.firePropertiesChanged(currentDir);
        }
    }

    @Override
    public void loadSettings(Settings settings) {
        this.m_bSaveCurrentDirOnExit = settings.getBoolean(SAVE_CURRENT_DIR_ON_EXIT, false);
        if (!this.m_bSaveCurrentDirOnExit) {
            return;
        }
        String currentDirStr = settings.get(CURRENT_DIR);
        if (currentDirStr == null || currentDirStr.length() == 0) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(currentDirStr, "\n");
        Object[] currentDirPath = new Object[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            currentDirPath[i++] = tok.nextToken();
        }
        this.selectDirForPathInternal(currentDirPath, false);
    }

    @Override
    public void saveSettings(Settings settings) {
        settings.setBoolean(SAVE_CURRENT_DIR_ON_EXIT, this.m_bSaveCurrentDirOnExit);
        if (!this.m_bSaveCurrentDirOnExit || this.getCurrentDirectory() == null) {
            settings.remove(CURRENT_DIR);
            return;
        }
        Object[] currentDirPath = this.m_dirTree.getSelectionPath().getPath();
        String str = "";
        for (int i = 0; i < currentDirPath.length; ++i) {
            str = str + currentDirPath[i].toString();
            if (i >= currentDirPath.length - 1) continue;
            str = str + "\n";
        }
        settings.set(CURRENT_DIR, str);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.getCurrentDirectory() != null) {
            ArrayList<AbstractFSObject> ls = new ArrayList<AbstractFSObject>(1);
            ls.add(this.getCurrentDirectory());
            this.fireSelectionChanged(ls);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

