/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.panel;

import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.ui.ExplorerMainFrame;
import com.dgrossmann.photo.ui.panel.IExplorerPanel;
import com.dgrossmann.photo.ui.panel.IExplorerPanelChangeListener;
import com.dgrossmann.photo.ui.panel.PanelTitleComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;

public abstract class AbstractExplorerPanel
extends JPanel
implements IExplorerPanel {
    private ExplorerMainFrame m_frame;
    private PanelTitleComponent m_panelTitleComponent;
    private List<IExplorerPanelChangeListener> m_changeListeners;
    private DirectoryObject m_currentDirectory;
    private List<AbstractFSObject> m_currentFsObjects;

    public AbstractExplorerPanel(ExplorerMainFrame frm, String initialTitleText) {
        this.m_frame = frm;
        this.m_panelTitleComponent = new PanelTitleComponent(initialTitleText);
        this.m_panelTitleComponent.setInactiveColors();
        this.m_changeListeners = new ArrayList<IExplorerPanelChangeListener>(2);
        this.m_currentDirectory = null;
        this.m_currentFsObjects = null;
    }

    @Override
    public JPanel getRootComponent() {
        return this;
    }

    public PanelTitleComponent getTitleLabel() {
        return this.m_panelTitleComponent;
    }

    public ExplorerMainFrame getFrame() {
        return this.m_frame;
    }

    @Override
    public void addChangeListener(IExplorerPanelChangeListener listener) {
        this.m_changeListeners.add(listener);
    }

    @Override
    public void removeChangeListener(IExplorerPanelChangeListener listener) {
        this.m_changeListeners.remove(listener);
    }

    public void setTitle(String title) {
        this.m_panelTitleComponent.setText(title == null || title.length() == 0 ? " " : title);
    }

    @Override
    public void setActiveColors() {
        this.m_panelTitleComponent.setActiveColors();
    }

    @Override
    public void setInactiveColors() {
        this.m_panelTitleComponent.setInactiveColors();
    }

    public DirectoryObject getCurrentDirectory() {
        return this.m_currentDirectory;
    }

    @Override
    public void setCurrentDirectory(DirectoryObject currentDirectory) {
        this.m_currentDirectory = currentDirectory;
    }

    public List<AbstractFSObject> getCurrentFSObjects() {
        return this.m_currentFsObjects;
    }

    @Override
    public void setCurrentFSObjects(List<AbstractFSObject> currentFsObjects) {
        this.m_currentFsObjects = currentFsObjects;
    }

    @Override
    public void setCurrentFSObject(AbstractFSObject fsObj) {
        ArrayList<AbstractFSObject> objs = new ArrayList<AbstractFSObject>(1);
        objs.add(fsObj);
        this.setCurrentFSObjects(objs);
    }

    public void fireCurrentDirectoryChanged(DirectoryObject currentDirObj) {
        Iterator<IExplorerPanelChangeListener> iter = this.m_changeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().onCurrentDirectoryChanged(this, currentDirObj);
        }
    }

    public void fireSelectionChanged(List<AbstractFSObject> currentFsObjects) {
        Iterator<IExplorerPanelChangeListener> iter = this.m_changeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().onSelectionChanged(this, currentFsObjects);
        }
    }

    public void firePropertiesChanged(AbstractFSObject fsObj) {
        Iterator<IExplorerPanelChangeListener> iter = this.m_changeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().onPropertiesChanged(this, fsObj);
        }
    }
}

