/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.ui.ExplorerMainFrame;
import com.dgrossmann.photo.webexport.ExportProgress;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;

public class ExportProgressDialog
extends JDialog {
    private ExplorerMainFrame m_parent;
    private ExportProgress m_progress;
    private int m_currentFileNumber;
    private int m_fileCount;
    private int m_pCurrent;
    private int m_pMax;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel currentFilePanel;
    private JPanel currentGroupPanel;
    private JLabel fileCountLabel;
    private JLabel groupLabel;
    private JLabel groupValLabel;
    private JLabel indexFileLabel;
    private JLabel indexFileSizeLabel;
    private JLabel indexLabel;
    private JSeparator jSeparator1;
    private JLabel mainFileLabel;
    private JLabel mainFileSizeLabel;
    private JLabel mainLabel;
    private JProgressBar progressBar;
    private JPanel progressPanel;
    private JLabel seriesLabel;
    private JLabel seriesValLabel;
    private JLabel sourceFileLabel;
    private JLabel sourceFileSizeLabel;
    private JLabel srcLabel;
    private JLabel titleLabel;
    private JLabel usingLabel;

    public ExportProgressDialog(ExplorerMainFrame parent, String exporterDescription, int fileCount) {
        super((Frame)parent, false);
        this.initComponents();
        this.setDefaultCloseOperation(0);
        this.m_parent = parent;
        this.m_fileCount = fileCount;
        this.m_currentFileNumber = 0;
        this.m_progress = null;
        this.fileCountLabel.setText("  " + this.m_fileCount + " files to export");
        this.m_pCurrent = 0;
        this.m_pMax = 3 * this.m_fileCount;
        if (exporterDescription.length() > 0) {
            this.usingLabel.setText("  Using " + exporterDescription);
        }
        Rectangle parentRect = parent.getBounds();
        Rectangle thisRect = this.getBounds();
        thisRect.x = parentRect.x + (parentRect.width - thisRect.width) / 2;
        thisRect.y = parentRect.y + (parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0) {
            thisRect.x = 0;
        }
        if (thisRect.y < 0) {
            thisRect.y = 0;
        }
        this.setBounds(thisRect);
    }

    private void setProgressValue() {
        if (this.m_pMax > 0) {
            this.progressBar.setValue(this.m_pCurrent * 100 / this.m_pMax);
        }
    }

    public void setProgress(ExportProgress p) {
        DirectoryObject parentDir;
        if (p == null) {
            return;
        }
        this.m_progress = p;
        if (this.m_currentFileNumber != this.m_progress.getCurrentFileNumber()) {
            this.m_currentFileNumber = this.m_progress.getCurrentFileNumber();
            this.m_pCurrent = 3 * (this.m_currentFileNumber - 1);
            this.setProgressValue();
            this.fileCountLabel.setText("  Exporting file " + this.m_currentFileNumber + " of " + this.m_fileCount);
        }
        if ((parentDir = (DirectoryObject)this.m_progress.getFileObject().getParent()) != null) {
            String series;
            String group = parentDir.getTitlePlain();
            if (parentDir.getParent() != null) {
                while (parentDir.getParent() != null) {
                    parentDir = (DirectoryObject)parentDir.getParent();
                }
                series = parentDir.getTitlePlain();
            } else {
                series = group;
                group = " ";
            }
            this.seriesValLabel.setText(series);
            this.groupLabel.setText(group.length() > 0 ? " Group:" : " ");
            this.groupValLabel.setText(group);
        }
        this.sourceFileLabel.setText(this.m_progress.getFileObject().getFullPath());
        Dimension dim = this.m_progress.getOriginalSize();
        if (dim != null) {
            this.m_pCurrent = 3 * (this.m_currentFileNumber - 1) + 1;
            this.setProgressValue();
            this.sourceFileSizeLabel.setText("" + dim.width + " x " + dim.height + " pixels");
        } else {
            this.sourceFileSizeLabel.setText(" ");
        }
        this.mainFileLabel.setText(" ");
        this.mainFileSizeLabel.setText(" ");
        this.indexFileLabel.setText(" ");
        this.indexFileSizeLabel.setText(" ");
        String outDir = this.m_progress.getOutputDirectory();
        String mainName = this.m_progress.getMainFileName();
        String indexName = this.m_progress.getIndexFileName();
        if (outDir.length() > 0) {
            if (mainName.length() > 0) {
                if (this.m_progress.isMainReady()) {
                    this.m_pCurrent = 3 * (this.m_currentFileNumber - 1) + 2;
                    this.setProgressValue();
                }
                this.mainFileLabel.setText(outDir + File.separator + mainName);
                if (this.m_progress.isMainUpToDate()) {
                    this.mainFileSizeLabel.setText("Up-to-date");
                } else {
                    dim = this.m_progress.getMainSize();
                    if (dim != null) {
                        this.mainFileSizeLabel.setText("" + dim.width + " x " + dim.height + " pixels" + (this.m_progress.isMainReady() ? " - Ready" : ""));
                    }
                }
            }
            if (indexName.length() > 0) {
                this.indexFileLabel.setText(outDir + File.separator + indexName);
                if (this.m_progress.isIndexUpToDate()) {
                    this.indexFileSizeLabel.setText("Up-to-date");
                } else {
                    dim = this.m_progress.getIndexSize();
                    if (dim != null) {
                        this.indexFileSizeLabel.setText("" + dim.width + " x " + dim.height + " pixels" + (this.m_progress.isIndexReady() ? " - Ready" : ""));
                    }
                }
            }
        }
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.usingLabel = new JLabel();
        this.currentGroupPanel = new JPanel();
        this.seriesLabel = new JLabel();
        this.seriesValLabel = new JLabel();
        this.groupLabel = new JLabel();
        this.groupValLabel = new JLabel();
        this.currentFilePanel = new JPanel();
        this.srcLabel = new JLabel();
        this.sourceFileLabel = new JLabel();
        this.sourceFileSizeLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.mainLabel = new JLabel();
        this.mainFileLabel = new JLabel();
        this.mainFileSizeLabel = new JLabel();
        this.indexLabel = new JLabel();
        this.indexFileLabel = new JLabel();
        this.indexFileSizeLabel = new JLabel();
        this.progressPanel = new JPanel();
        this.progressBar = new JProgressBar();
        this.bottomPanel = new JPanel();
        this.fileCountLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Web Export Progress");
        this.setResizable(false);
        this.titleLabel.setText("  The images are being exported to the Web export directory.  Please be patient for a moment.       ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.getContentPane().add((Component)this.titleLabel, gridBagConstraints);
        this.usingLabel.setText("  Using");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.usingLabel, gridBagConstraints);
        this.currentGroupPanel.setLayout(new FlowLayout(1, 6, 5));
        this.currentGroupPanel.setBorder(BorderFactory.createTitledBorder(null, "Current Group"));
        this.seriesLabel.setText("Series:");
        this.currentGroupPanel.add(this.seriesLabel);
        this.seriesValLabel.setForeground(new Color(0, 70, 213));
        this.seriesValLabel.setText(" ");
        this.currentGroupPanel.add(this.seriesValLabel);
        this.groupLabel.setText(" ");
        this.currentGroupPanel.add(this.groupLabel);
        this.groupValLabel.setForeground(new Color(0, 70, 213));
        this.groupValLabel.setText(" ");
        this.currentGroupPanel.add(this.groupValLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.currentGroupPanel, gridBagConstraints);
        this.currentFilePanel.setLayout(new GridBagLayout());
        this.currentFilePanel.setBorder(BorderFactory.createTitledBorder(null, "Current File"));
        this.srcLabel.setText("Source:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.currentFilePanel.add((Component)this.srcLabel, gridBagConstraints);
        this.sourceFileLabel.setForeground(new Color(0, 70, 213));
        this.sourceFileLabel.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        this.currentFilePanel.add((Component)this.sourceFileLabel, gridBagConstraints);
        this.sourceFileSizeLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        this.currentFilePanel.add((Component)this.sourceFileSizeLabel, gridBagConstraints);
        this.jSeparator1.setForeground(new Color(208, 208, 191));
        this.jSeparator1.setMinimumSize(new Dimension(3, 3));
        this.jSeparator1.setPreferredSize(new Dimension(6, 3));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.currentFilePanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.mainLabel.setText("Main Image:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 6, 0, 0);
        this.currentFilePanel.add((Component)this.mainLabel, gridBagConstraints);
        this.mainFileLabel.setForeground(new Color(0, 70, 213));
        this.mainFileLabel.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.currentFilePanel.add((Component)this.mainFileLabel, gridBagConstraints);
        this.mainFileSizeLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        this.currentFilePanel.add((Component)this.mainFileSizeLabel, gridBagConstraints);
        this.indexLabel.setText("Index Image:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.currentFilePanel.add((Component)this.indexLabel, gridBagConstraints);
        this.indexFileLabel.setForeground(new Color(0, 70, 213));
        this.indexFileLabel.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.currentFilePanel.add((Component)this.indexFileLabel, gridBagConstraints);
        this.indexFileSizeLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.currentFilePanel.add((Component)this.indexFileSizeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.currentFilePanel, gridBagConstraints);
        this.progressPanel.setLayout(new GridBagLayout());
        this.progressPanel.setBorder(BorderFactory.createTitledBorder(null, "Overall Progress"));
        this.progressBar.setForeground(new Color(0, 70, 213));
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        this.progressPanel.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.progressPanel, gridBagConstraints);
        this.bottomPanel.setLayout(new GridBagLayout());
        this.fileCountLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        this.bottomPanel.add((Component)this.fileCountLabel, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportProgressDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        this.bottomPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.getContentPane().add((Component)this.bottomPanel, gridBagConstraints);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.m_parent.stopExport();
        this.fileCountLabel.setText("  Export is being canceled ...");
        this.cancelButton.setEnabled(false);
    }
}

