/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.ui.ImageHolder;
import com.dgrossmann.photo.ui.panel.contents.ContentsTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class AssociateFileTableModel
extends ContentsTableModel {
    private static final String[] s_columnNames = new String[]{"", "File Name", "Titel", "Modified"};
    private static final Class<?>[] s_columnTypes = new Class[]{ImageIcon.class, String.class, String.class, String.class};
    private List<FileObject> m_files;

    public AssociateFileTableModel(Component parent, ImageHolder imgHolder) {
        super(parent, null, imgHolder);
        this.m_bWithImagePreview = false;
        this.m_files = null;
    }

    private void setFileList(DirectoryObject dirObj) {
        int fileCount = dirObj.getFileCount();
        this.m_files = new ArrayList<FileObject>(fileCount);
        for (int i = 0; i < fileCount; ++i) {
            FileObject fileObj = dirObj.getFileAt(i);
            if (fileObj.isReference()) continue;
            this.m_files.add(fileObj);
        }
    }

    @Override
    public void setCurrentDir(DirectoryObject currentDir) {
        this.setFileList(currentDir);
        super.setCurrentDir(currentDir);
    }

    @Override
    public void refresh() {
        this.setFileList(this.m_currentDir);
        super.refresh();
    }

    @Override
    public int getColumnCount() {
        return s_columnNames.length;
    }

    @Override
    public String getColumnName(int index) {
        return s_columnNames[index];
    }

    @Override
    public Class<?> getColumnClass(int index) {
        return s_columnTypes[index];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.m_files != null ? this.m_files.size() : 0;
    }

    public FileObject getFileAt(int index) {
        if (this.m_files == null || index < 0 || index >= this.m_files.size()) {
            return null;
        }
        return this.m_files.get(index);
    }

    @Override
    public Object getValueAt(int row, int column) {
        FileObject fe = this.getFileAt(row);
        if (fe == null) {
            return "";
        }
        switch (column) {
            case 0: {
                return this.getTypeImage(fe);
            }
            case 1: {
                return fe.getFileName();
            }
            case 2: {
                if (fe.isSeparator()) {
                    return "---------";
                }
                return fe.getTitle(true);
            }
            case 3: {
                return fe.getModDateTimeString(true);
            }
        }
        return "";
    }
}

