/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.ui.dialog;

import com.dgrossmann.photo.AppInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutDialog
extends JDialog {
    private JButton closeButton;
    private JLabel copyrightLabel;
    private JLabel dateLabel;
    private JPanel descPanel;
    private JLabel iconLabel;
    private JLabel versionLabel;

    public AboutDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setResizable(false);
        this.setTitle("About J Photo-Explorer");
        this.versionLabel.setText("Version " + AppInfo.getVersionString());
        this.dateLabel.setText(AppInfo.getBuildDate(false));
        this.copyrightLabel.setText("Copyright \u00a9 2014 by Dirk S. Grossmann");
        Font fn = this.versionLabel.getFont();
        Font newFont = fn.deriveFont(1, 14.0f);
        this.versionLabel.setFont(newFont);
        this.copyrightLabel.setFont(newFont);
        Rectangle parentRect = parent.getBounds();
        Rectangle thisRect = this.getBounds();
        thisRect.x = parentRect.x + (parentRect.width - thisRect.width) / 2;
        thisRect.y = parentRect.y + (parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0) {
            thisRect.x = 0;
        }
        if (thisRect.y < 0) {
            thisRect.y = 0;
        }
        this.setBounds(thisRect);
    }

    private void initComponents() {
        this.descPanel = new JPanel();
        this.versionLabel = new JLabel();
        this.dateLabel = new JLabel();
        this.copyrightLabel = new JLabel();
        this.iconLabel = new JLabel();
        this.closeButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("About");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.closeDialog(evt);
            }
        });
        this.descPanel.setLayout(new GridBagLayout());
        this.versionLabel.setText("Version");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(84, 72, 0, 0);
        this.descPanel.add((Component)this.versionLabel, gridBagConstraints);
        this.dateLabel.setText("of");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 72, 0, 0);
        this.descPanel.add((Component)this.dateLabel, gridBagConstraints);
        this.copyrightLabel.setForeground(new Color(255, 255, 255));
        this.copyrightLabel.setText("Copyright");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(0, 5, 1, 0);
        this.descPanel.add((Component)this.copyrightLabel, gridBagConstraints);
        this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/jp-logo.jpg")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 11;
        this.descPanel.add((Component)this.iconLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.descPanel, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.closeButton, gridBagConstraints);
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

