/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.settings;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Settings {
    public static final int EXPDEFAULT_MAINIMG_LENGTH = 600;
    public static final int EXPDEFAULT_MAINIMG_MAX_WIDTH = 700;
    public static final int EXPDEFAULT_MAINIMG_MAX_HEIGHT = 450;
    public static final int EXPDEFAULT_MAINIMG_QUALITY = 85;
    public static final int EXPDEFAULT_INDEXIMG_LENGTH = 200;
    public static final int EXPDEFAULT_INDEXIMG_QUALITY = 75;
    public static final String DEFAULT_COPYRIGHT_STRING = "\u00a9 ${year}";
    public static final String METADEFAULT_XML_ENCODING = "ISO-8859-1";
    public static final String GALLERY_TITLE = "gallery.title";
    public static final String GALLERY_DESCRIPTION = "gallery.description";
    public static final String GALLERY_COPYRIGHT = "gallery.copyright";
    public static final String SERIES_CONTAINER_PREFIX = "series.container.";
    public static final String EXPORT_DIRECTORY = "export.dir";
    public static final String EXPORT_MAINIMG_LENGTH = "export.mainimg.length";
    public static final String EXPORT_MAINIMG_MAX_WIDTH = "export.mainimg.max_width";
    public static final String EXPORT_MAINIMG_MAX_HEIGHT = "export.mainimg.max_height";
    public static final String EXPORT_MAINIMG_QUALITY = "export.mainimg.quality";
    public static final String EXPORT_INDEXIMG_LENGTH = "export.indeximg.length";
    public static final String EXPORT_INDEXIMG_QUALITY = "export.indeximg.quality";
    public static final String EXPORT_USE_IMAGE_MAGICK = "export.use_magick";
    public static final String METADATA_SAVE_XML = "metadata.save.xml";
    public static final String METADATA_SAVE_ENCODING = "metadata.save.xml.encoding";
    public static final String METADATA_EXPORT_XML = "metadata.export.xml";
    public static final String METADATA_EXPORT_ENCODING = "metadata.export.xml.encoding";
    private File m_settingsFile;
    private Properties m_properties;
    private ArrayList<String> m_seriesContainerNames;

    public Settings(String settingsFileName) {
        this.m_settingsFile = new File(settingsFileName);
        if (!this.m_settingsFile.exists() && !this.m_settingsFile.isAbsolute()) {
            this.m_settingsFile = new File(System.getProperty("user.home"), settingsFileName);
        }
        this.m_properties = new Properties();
        this.m_seriesContainerNames = new ArrayList();
        this.setInt(EXPORT_USE_IMAGE_MAGICK, 1);
        try {
            String name;
            String dir;
            this.m_properties.load(new FileInputStream(this.m_settingsFile));
            int i = 1;
            while ((dir = this.get(name = SERIES_CONTAINER_PREFIX + i)) != null && dir.length() != 0) {
                this.m_properties.remove(name);
                this.addSeriesContainer(dir);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Iterator<String> getSeriesContainerNameIterator() {
        return this.m_seriesContainerNames.iterator();
    }

    public void addSeriesContainer(String containerDirName) {
        if (!this.m_seriesContainerNames.contains(containerDirName)) {
            this.m_seriesContainerNames.add(containerDirName);
        }
    }

    public String get(String name) {
        String val = this.m_properties.getProperty(name);
        return val != null ? val : "";
    }

    public String get(String name, String defaultValue) {
        String val = this.get(name);
        return val.length() > 0 ? val : defaultValue;
    }

    public void set(String name, String val) {
        this.m_properties.setProperty(name, val != null ? val.trim() : "");
    }

    public void remove(String name) {
        this.m_properties.remove(name);
    }

    public int getInt(String name, int defaultValue) {
        try {
            String val = this.m_properties.getProperty(name);
            if (val != null) {
                return Integer.parseInt(val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public void setInt(String name, int val) {
        this.m_properties.setProperty(name, Integer.toString(val));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        try {
            String val = this.m_properties.getProperty(name);
            if (val != null && val.length() > 0) {
                char ch = Character.toLowerCase(val.charAt(0));
                return ch == 't' || ch == 'y' || ch == '1';
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public void setBoolean(String name, boolean val) {
        this.m_properties.setProperty(name, val ? "true" : "false");
    }

    public Rectangle getRect(String name) {
        String valStr = this.m_properties.getProperty(name);
        if (valStr == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(valStr, ",");
        if (tok.countTokens() < 4) {
            return null;
        }
        try {
            Rectangle rect = new Rectangle();
            rect.x = Integer.parseInt(tok.nextToken());
            rect.y = Integer.parseInt(tok.nextToken());
            rect.width = Integer.parseInt(tok.nextToken());
            rect.height = Integer.parseInt(tok.nextToken());
            return rect;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public void setRect(String name, Rectangle rect) {
        this.m_properties.setProperty(name, Integer.toString(rect.x) + "," + rect.y + "," + rect.width + "," + rect.height);
    }

    public String[] getUsedPropertyNames() {
        return this.m_properties.keySet().toArray(new String[0]);
    }

    public void save() {
        try {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)this.m_properties);
            if (!this.m_seriesContainerNames.isEmpty()) {
                int count = this.m_seriesContainerNames.size();
                for (int i = 1; i <= count; ++i) {
                    props.setProperty(SERIES_CONTAINER_PREFIX + i, this.m_seriesContainerNames.get(i - 1).toString());
                }
            }
            try {
                Iterator<Object> iter = props.keySet().iterator();
                while (iter.hasNext()) {
                    String name = iter.next().toString();
                    String val = props.getProperty(name);
                    if (val != null && val.length() != 0) continue;
                    props.remove(name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            props.store(new FileOutputStream(this.m_settingsFile), "J Photo-Explorer Settings");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

