/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.dir.persist;

import com.dgrossmann.photo.AppInfo;
import com.dgrossmann.photo.dir.AbstractFSObject;
import com.dgrossmann.photo.dir.DirectoryObject;
import com.dgrossmann.photo.dir.FileObject;
import com.dgrossmann.photo.dir.persist.AbstractDirPersist;
import com.dgrossmann.photo.dir.persist.PersistException;
import com.dgrossmann.photo.settings.Settings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DirPersistXmlFile
extends AbstractDirPersist {
    private static final String DEFAULT_NAMESPACE = "http://www.dgrossmann.com/photo/metadata";
    private static final String ELEM_SERIES = "series";
    private static final String ELEM_GROUP = "group";
    private static final String ELEM_CONTENTS = "contents";
    private static final String ELEM_SEPARATOR = "separator";
    private static final String ELEM_FILE = "file";
    private static final String ELEM_TITLE = "title";
    private static final String ELEM_SUBTITLE = "subtitle";
    private static final String ELEM_LOCATION = "location";
    private static final String ELEM_DESCRIPTION = "description";
    private static final String ELEM_REMARK = "remark";
    private static final String ELEM_PROPERTY = "property";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_REFERENCE = "is-reference";
    private static final String ATTR_HREF = "href";
    private static final String ATTR_BEGIN_DATE = "begin-date";
    private static final String ATTR_END_DATE = "end-date";
    private static final String ATTR_EXPORT = "export";
    private static final String ATTR_EXPORT_QUALITY = "quality";
    private static final String ATTR_WEB_EXPORTED = "web-exported";
    private String m_saveXmlEncoding = "ISO-8859-1";
    private String m_exportXmlEncoding = "ISO-8859-1";

    public DirPersistXmlFile(Settings settings) {
        super(settings);
    }

    public void setEncodings(String saveXmlEncoding, String exportXmlEncoding) {
        this.m_saveXmlEncoding = saveXmlEncoding;
        this.m_exportXmlEncoding = exportXmlEncoding;
    }

    @Override
    protected String getMetaDataStoreName(DirectoryObject seriesDirObj, boolean bAbsolute) {
        String name = seriesDirObj.getFileName().toLowerCase();
        name = '_' + name.replace(' ', '-') + "-metadata.xml";
        if (!bAbsolute) {
            return seriesDirObj.getFileName().toLowerCase() + File.separator + name;
        }
        return seriesDirObj.getFullPath() + File.separator + name;
    }

    @Override
    public boolean canLoad(DirectoryObject seriesDirObj) {
        String fileName = this.getMetaDataStoreName(seriesDirObj, true);
        return new File(fileName).exists();
    }

    @Override
    protected void readMetaDataStore(DirectoryObject seriesDirObj, String metaDataFileName) throws PersistException {
        File metaDataFile = new File(metaDataFileName);
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setValidating(false);
            DocumentBuilder builder = fac.newDocumentBuilder();
            Document doc = builder.parse(metaDataFile);
            Element rootElem = doc.getDocumentElement();
            if (!rootElem.getTagName().equals(ELEM_SERIES)) {
                PersistException pe = new PersistException(1, (Object)seriesDirObj, metaDataFile.getAbsolutePath(), "This file is not a JPhoto-Explorer series meta data file as it does not have the <series> root element");
                pe.log();
                throw pe;
            }
            if (rootElem.hasAttribute(ATTR_WEB_EXPORTED)) {
                PersistException pe = new PersistException(1, (Object)seriesDirObj, metaDataFile.getAbsolutePath(), "This is a metadata file for a Web directory and cannot be loaded as series directory");
                pe.log();
                throw pe;
            }
            this.readDescription(seriesDirObj, rootElem);
            this.readGroup(seriesDirObj, rootElem);
        }
        catch (Exception exc) {
            PersistException pe = new PersistException(1, (Object)seriesDirObj, metaDataFile.getAbsolutePath(), exc);
            pe.log();
            throw pe;
        }
    }

    private void readGroup(DirectoryObject parentDirObj, Element dirElement) {
        Element elem;
        Node n;
        int i;
        Node contentsElement = null;
        NodeList children = dirElement.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            n = children.item(i);
            if (!(n instanceof Element) || !(elem = (Element)n).getTagName().equals(ELEM_CONTENTS)) continue;
            contentsElement = elem;
            break;
        }
        if (contentsElement == null) {
            return;
        }
        children = contentsElement.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            n = children.item(i);
            if (!(n instanceof Element)) continue;
            elem = (Element)n;
            String name = elem.getTagName();
            if (name.equals(ELEM_GROUP)) {
                DirectoryObject dirObj = new DirectoryObject("", parentDirObj);
                parentDirObj.addChild(dirObj, -1);
                this.readDescription(dirObj, elem);
                this.readGroup(dirObj, elem);
                continue;
            }
            if (!name.equals(ELEM_FILE) && !name.equals(ELEM_SEPARATOR)) continue;
            FileObject fileObj = new FileObject("", parentDirObj);
            parentDirObj.addChild(fileObj, -1);
            this.readDescription(fileObj, elem);
            if (!name.equals(ELEM_SEPARATOR)) continue;
            fileObj.makeSeparator();
        }
    }

    private void readDescription(AbstractFSObject fsObj, Element fsElement) {
        Attr attrib = fsElement.getAttributeNode(ATTR_NAME);
        if (attrib != null) {
            fsObj.setFileNamePart(attrib.getValue());
        }
        if ((attrib = fsElement.getAttributeNode(ATTR_BEGIN_DATE)) != null) {
            fsObj.set("date-begin", attrib.getValue());
        }
        if ((attrib = fsElement.getAttributeNode(ATTR_END_DATE)) != null) {
            fsObj.set("date-end", attrib.getValue());
        }
        if (fsElement.hasAttribute(ATTR_REFERENCE)) {
            fsObj.setReference(true);
            attrib = fsElement.getAttributeNode(ATTR_HREF);
            if (attrib != null) {
                fsObj.set(ATTR_HREF, attrib.getValue());
            }
        }
        if ((attrib = fsElement.getAttributeNode(ATTR_EXPORT)) != null) {
            int ch = 102;
            String value = attrib.getValue();
            if (value != null) {
                value = value.trim();
            }
            if (value.length() > 0) {
                ch = value.charAt(0);
            }
            fsObj.setToExport(ch == 116 || ch == 121 || ch == 49);
        } else {
            fsObj.setToExport(false);
        }
        attrib = fsElement.getAttributeNode(ATTR_EXPORT_QUALITY);
        if (attrib != null) {
            try {
                int quality = Integer.parseInt(attrib.getValue());
                fsObj.setConversionQuality(quality);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        for (Node subNode = fsElement.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
            if (!(subNode instanceof Element)) continue;
            String name = ((Element)subNode).getTagName();
            if (name.equals(ELEM_TITLE)) {
                fsObj.set(ELEM_TITLE, DirPersistXmlFile.getTextContent(subNode));
                continue;
            }
            if (name.equals(ELEM_SUBTITLE)) {
                fsObj.set(ELEM_SUBTITLE, DirPersistXmlFile.getTextContent(subNode));
                continue;
            }
            if (name.equals(ELEM_DESCRIPTION)) {
                fsObj.set(ELEM_DESCRIPTION, DirPersistXmlFile.getTextContent(subNode));
                continue;
            }
            if (name.equals(ELEM_LOCATION)) {
                fsObj.set(ELEM_LOCATION, DirPersistXmlFile.getTextContent(subNode));
                continue;
            }
            if (name.equals(ELEM_REMARK)) {
                fsObj.set(ELEM_REMARK, DirPersistXmlFile.getTextContent(subNode));
                continue;
            }
            if (!name.equals(ELEM_PROPERTY)) continue;
            name = ((Element)subNode).getAttributeNode(ATTR_NAME).getValue();
            fsObj.set(name, DirPersistXmlFile.getTextContent(subNode));
        }
    }

    private static String getTextContent(Node node) {
        short type = node.getNodeType();
        if (type == 8 || type == 7) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        String value = node.getNodeValue();
        if (value != null) {
            text.append(value);
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                text.append(DirPersistXmlFile.getTextContent(child));
            }
        }
        return text.toString().trim();
    }

    @Override
    protected void internalSave(DirectoryObject seriesDirObj, String metadataStoreName, boolean bForWeb) throws PersistException {
        File metaDataFile = new File(metadataStoreName);
        try (PrintWriter writer = null;){
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setValidating(false);
            DocumentBuilder builder = fac.newDocumentBuilder();
            Document doc = builder.newDocument();
            Comment comment = doc.createComment("J Photo-Explorer (Version " + AppInfo.getVersionString() + ")" + (bForWeb ? " Web-exported" : "") + " photo series metadata file.");
            doc.appendChild(comment);
            DateFormat df = DateFormat.getDateTimeInstance(1, 2);
            comment = doc.createComment("Created: " + df.format(new Date()));
            doc.appendChild(comment);
            if (bForWeb) {
                comment = doc.createComment("Metadata exported for the Web. Do not load as regular series metadata.");
                doc.appendChild(comment);
            }
            Element rootElem = doc.createElementNS(DEFAULT_NAMESPACE, ELEM_SERIES);
            doc.appendChild(rootElem);
            if (bForWeb) {
                rootElem.setAttribute(ATTR_WEB_EXPORTED, "yes");
            }
            this.writeDescription(seriesDirObj, bForWeb, rootElem, doc);
            this.writeGroupBody(seriesDirObj, bForWeb, rootElem, doc);
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer xForm = xformFactory.newTransformer();
            xForm.setOutputProperty("encoding", bForWeb ? this.m_exportXmlEncoding : this.m_saveXmlEncoding);
            xForm.setOutputProperty("indent", "yes");
            DOMSource input = new DOMSource(doc);
            StreamResult output = new StreamResult(new PrintWriter(new FileOutputStream(metaDataFile)));
            xForm.transform(input, output);
        }
    }

    private void writeGroupBody(DirectoryObject dirObj, boolean bForWeb, Element dirElem, Document doc) throws Exception {
        Element elem;
        Element contentsElem = doc.createElement(ELEM_CONTENTS);
        dirElem.appendChild(contentsElem);
        Iterator<DirectoryObject> subDirIter = dirObj.getSubDirIterator();
        while (subDirIter.hasNext()) {
            DirectoryObject subDir = subDirIter.next();
            if (bForWeb && !subDir.isToExport()) continue;
            elem = doc.createElement(ELEM_GROUP);
            contentsElem.appendChild(elem);
            this.writeDescription(subDir, bForWeb, elem, doc);
            this.writeGroupBody(subDir, bForWeb, elem, doc);
        }
        Iterator<FileObject> fileIter = dirObj.getFileIterator();
        while (fileIter.hasNext()) {
            FileObject fileObj = fileIter.next();
            if (bForWeb && !fileObj.isToExport()) continue;
            elem = doc.createElement(fileObj.isSeparator() ? ELEM_SEPARATOR : ELEM_FILE);
            contentsElem.appendChild(elem);
            this.writeDescription(fileObj, bForWeb, elem, doc);
        }
    }

    private void writeDescription(AbstractFSObject fsObj, boolean bForWeb, Element fsObjElem, Document doc) throws Exception {
        Element elem;
        String val;
        String name;
        if (fsObj instanceof DirectoryObject) {
            name = fsObj.getFileName();
        } else if (fsObj.isReference()) {
            name = fsObj.getFileNamePart();
        } else if (bForWeb) {
            FileObject fileObj = (FileObject)fsObj;
            name = fileObj.getFileType() != 1 ? fileObj.getFileName() : fileObj.getBaseFileName() + ".jpg";
            name = name.toLowerCase();
        } else {
            name = fsObj.getFileName();
        }
        if (name.length() == 0) {
            name = fsObj.getFileNamePart();
        }
        if (bForWeb) {
            name = name.toLowerCase();
        }
        fsObjElem.setAttribute(ATTR_NAME, name);
        String[] propNames = fsObj.getUsedPropertyNames();
        for (int i = 0; i < propNames.length; ++i) {
            val = fsObj.getTransformed(propNames[i], true);
            if (val == null || val.trim().length() == 0) continue;
            if (propNames[i].equals("date-begin")) {
                fsObjElem.setAttribute(ATTR_BEGIN_DATE, val);
                continue;
            }
            if (propNames[i].equals("date-end")) {
                fsObjElem.setAttribute(ATTR_END_DATE, val);
                continue;
            }
            if (propNames[i].equals(ATTR_HREF)) {
                fsObjElem.setAttribute(ATTR_HREF, val);
                continue;
            }
            if (propNames[i].equals(ELEM_TITLE)) {
                elem = doc.createElement(ELEM_TITLE);
                elem.appendChild(doc.createCDATASection(val));
                fsObjElem.appendChild(elem);
                continue;
            }
            if (propNames[i].equals(ELEM_SUBTITLE)) {
                elem = doc.createElement(ELEM_SUBTITLE);
                elem.appendChild(doc.createCDATASection(val));
                fsObjElem.appendChild(elem);
                continue;
            }
            if (propNames[i].equals(ELEM_DESCRIPTION)) {
                elem = doc.createElement(ELEM_DESCRIPTION);
                elem.appendChild(doc.createCDATASection(val));
                fsObjElem.appendChild(elem);
                continue;
            }
            if (propNames[i].equals(ELEM_LOCATION)) {
                elem = doc.createElement(ELEM_LOCATION);
                elem.appendChild(doc.createCDATASection(val));
                fsObjElem.appendChild(elem);
                continue;
            }
            if (propNames[i].equals(ELEM_REMARK)) {
                elem = doc.createElement(ELEM_REMARK);
                elem.appendChild(doc.createCDATASection(val));
                fsObjElem.appendChild(elem);
                continue;
            }
            elem = doc.createElement(ELEM_PROPERTY);
            elem.setAttribute(ATTR_NAME, propNames[i]);
            elem.appendChild(doc.createCDATASection(val));
            fsObjElem.appendChild(elem);
        }
        if (fsObj.isReference()) {
            fsObjElem.setAttribute(ATTR_REFERENCE, "yes");
        }
        if (bForWeb) {
            val = fsObj.getTitle(false);
            if ((val = AbstractFSObject.transformAccents(val, true)).length() == 0) {
                elem = doc.createElement(ELEM_TITLE);
                val = fsObj.getTitle(true);
                val = AbstractFSObject.transformAccents(val, true);
                elem.appendChild(doc.createCDATASection(val));
                fsObjElem.appendChild(elem);
            }
        } else if (fsObj.isToExport()) {
            fsObjElem.setAttribute(ATTR_EXPORT, "yes");
            if (fsObj.getConversionQuality() > 0) {
                fsObjElem.setAttribute(ATTR_EXPORT_QUALITY, Integer.toString(fsObj.getConversionQuality()));
            }
        } else {
            fsObjElem.setAttribute(ATTR_EXPORT, "no");
        }
    }
}

