/*
 * Decompiled with CFR 0.152.
 */
package com.dgrossmann.photo.dir;

import com.dgrossmann.photo.dir.DirectoryObject;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.StringTokenizer;

public abstract class AbstractFSObject {
    public static final String TITLE = "title";
    public static final String SUBTITLE = "subtitle";
    public static final String HREF = "href";
    public static final String DATE = "date";
    public static final String DATE_BEGIN = "date-begin";
    public static final String DATE_END = "date-end";
    public static final String LOCATION = "location";
    public static final String DESCRIPTION = "description";
    public static final String REMARK = "remark";
    public static final String REFERENCE = "reference:";
    protected AbstractFSObject m_parent;
    protected HashMap<String, String> m_properties;
    protected String m_fileName;
    protected String m_fileNamePart;
    protected boolean m_isReference;
    protected Calendar m_lastModified;
    protected boolean m_bToExport;
    protected int m_jpegQuality;
    private static final String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] CHAR_TAB = new String[]{"\u00c4", "&Auml;", "\u00d6", "&Ouml;", "\u00dc", "&Uuml;", "\u00e4", "&auml;", "\u00ef", "&iuml;", "\u00f6", "&ouml;", "\u00fc", "&uuml;", "\u00ff", "&yuml;", "\u00df", "&szlig;", "\u00c1", "&Aacute;", "\u00c9", "&Eacute;", "\u00cd", "&Iacute;", "\u00d3", "&Oacute;", "\u00da", "&Uacute;", "\u00e1", "&aacute;", "\u00e9", "&eacute;", "\u00ed", "&iacute;", "\u00f3", "&oacute;", "\u00fa", "&uacute;", "\u00c0", "&Agrave;", "\u00c8", "&Egrave;", "\u00cc", "&Igrave;", "\u00d2", "&Ograve;", "\u00d9", "&Ugrave;", "\u00e0", "&agrave;", "\u00e8", "&egrave;", "\u00ec", "&igrave;", "\u00f2", "&ograve;", "\u00f9", "&ugrave;", "\u00c2", "&Acirc;", "\u00ca", "&Ecirc;", "\u00ce", "&Icirc;", "\u00d4", "&Ocirc;", "\u00db", "&Ucirc;", "\u00e2", "&acirc;", "\u00ea", "&ecirc;", "\u00ee", "&icirc;", "\u00f4", "&ocirc;", "\u00fb", "&ucirc;", "\u00c3", "&Atilde;", "\u00d1", "&Ntilde;", "\u00d5", "&Otilde;", "\u00e3", "&atilde;", "\u00f1", "&ntilde;", "\u00f5", "&otilde;", "\u00c7", "&Ccedil;", "\u00e7", "&ccedil;"};

    public AbstractFSObject(AbstractFSObject parentObj) {
        this.m_parent = parentObj;
        this.m_properties = new HashMap(10);
        this.m_fileNamePart = "";
        this.m_fileName = "";
        this.m_isReference = false;
        this.m_lastModified = null;
        this.m_bToExport = true;
        this.m_jpegQuality = 0;
    }

    public AbstractFSObject getParent() {
        return this.m_parent;
    }

    public boolean isEmpty() {
        if (!this.isReference()) {
            return false;
        }
        return this.getTitle(false).length() == 0 && this.get(DESCRIPTION).length() == 0 && this.get(SUBTITLE).length() == 0 && this.get(HREF).length() == 0;
    }

    public boolean isReference() {
        return this.m_isReference;
    }

    public void setReference(boolean bIsRef) {
        this.m_isReference = bIsRef;
        if (this.m_isReference) {
            this.setFileNamePart(REFERENCE);
            this.setFileName("", false);
        } else {
            this.setFileNamePart("");
        }
    }

    public String getFullPath() {
        String name = this.m_fileName;
        if (name.length() == 0) {
            return "";
        }
        if (this.getParent() != null) {
            return this.getParent().getFullPath() + File.separator + name;
        }
        return name;
    }

    public String getPath(boolean bIncludeSeriesName) {
        if (this.m_fileName.equals("") && this.getParent() == null) {
            return "";
        }
        if (this.getParent() != null) {
            String path = this.getParent().getPath(bIncludeSeriesName);
            if (path != null && path.length() > 0) {
                path = path + File.separator;
            }
            return path + this.m_fileName;
        }
        return bIncludeSeriesName ? this.getFileName() : "";
    }

    public Calendar getModDateTime() {
        if (this.m_lastModified != null) {
            return this.m_lastModified;
        }
        if (this.getFullPath().length() == 0) {
            return null;
        }
        File f = new File(this.getFullPath());
        if (!f.exists()) {
            return null;
        }
        long modTime = f.lastModified();
        if (modTime == 0L) {
            return null;
        }
        this.m_lastModified = Calendar.getInstance();
        this.m_lastModified.setTimeInMillis(modTime);
        return this.m_lastModified;
    }

    public String getModDateTimeString(boolean bShort) {
        Calendar cal = this.getModDateTime();
        if (cal == null) {
            return "";
        }
        int min = cal.get(12);
        int hour = cal.get(11);
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        String str = " (" + (hour <= 9 ? "0" : "") + hour + ":" + (min <= 9 ? "0" : "") + min + ")";
        if (bShort) {
            str = (day <= 9 ? "0" : "") + day + "." + (month <= 9 ? "0" : "") + month + "." + year + str;
            return str;
        }
        return day + "  " + monthNames[month - 1] + ", " + year + str;
    }

    public String expandDate(String dateString, boolean bShort) {
        if (dateString.length() == 0) {
            return "";
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int min = 0;
        int sec = 0;
        StringTokenizer tokens = new StringTokenizer(dateString, "-");
        try {
            if (tokens.hasMoreTokens()) {
                year = Integer.parseInt(tokens.nextToken());
            }
            if (tokens.hasMoreTokens()) {
                month = Integer.parseInt(tokens.nextToken());
            }
            if (tokens.hasMoreTokens()) {
                day = Integer.parseInt(tokens.nextToken());
            }
            if (tokens.hasMoreTokens()) {
                hour = Integer.parseInt(tokens.nextToken());
            }
            if (tokens.hasMoreTokens()) {
                min = Integer.parseInt(tokens.nextToken());
            }
            if (tokens.hasMoreTokens()) {
                sec = Integer.parseInt(tokens.nextToken());
            }
        }
        catch (Exception e) {
            return dateString;
        }
        String str = "";
        if (bShort) {
            if (day > 0) {
                str = str + (day <= 9 ? "0" : "") + day + ".";
            }
            if (month > 0) {
                str = str + (month <= 9 ? "0" : "") + month + ".";
            }
            if (year > 0) {
                str = str + year;
            }
            return str;
        }
        if (day > 0) {
            str = str + day + " ";
        }
        if (month > 0) {
            str = str + monthNames[month - 1];
        }
        str = day > 0 ? str + ", " : str + " ";
        if (year > 0) {
            str = str + year;
        }
        if (hour > 0) {
            str = str + " (" + (hour <= 9 ? "0" : "") + hour + ":" + (min <= 9 ? "0" : "") + min;
            if (sec > 0) {
                str = str + ":" + (sec <= 9 ? "0" : "") + sec;
            }
            str = str + ")";
        }
        return str;
    }

    public String getFileSizeStr(boolean bInKB) {
        return null;
    }

    public String getBeginDate(boolean bExpanded) {
        String dateString = this.get(DATE_BEGIN);
        if ((dateString == null || dateString.length() == 0) && this instanceof DirectoryObject && this.getFileName() != null && this.getFileName().matches("^[0-9]{4}[-_ ].*")) {
            dateString = this.getFileName().substring(0, 4);
            this.set(DATE_BEGIN, dateString);
        }
        if (!bExpanded) {
            return dateString;
        }
        return this.expandDate(dateString, false);
    }

    public Integer getYear() {
        StringTokenizer tok;
        Integer val = null;
        String str = this.getBeginDate(false);
        if (str != null && str.length() > 0 && (tok = new StringTokenizer(str, "-")).hasMoreTokens()) {
            val = new Integer(tok.nextToken().trim());
        }
        if (val == null && this.getParent() != null) {
            return this.getParent().getYear();
        }
        return val;
    }

    public String getEndDate(boolean bExpanded) {
        String dateString = this.get(DATE_END);
        if (!bExpanded) {
            return dateString;
        }
        return this.expandDate(dateString, false);
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public boolean setFileName(String name, boolean bRenameFile) {
        File oldFile = null;
        if (name == null) {
            name = "";
        }
        name = name.trim();
        if (bRenameFile && name.length() > 0 && !this.m_fileName.equalsIgnoreCase(name) && !(oldFile = new File(this.getFullPath())).exists()) {
            oldFile = null;
        }
        if (this.m_parent != null) {
            this.m_fileName = name;
        } else {
            int index;
            String path = this.m_fileName;
            if (File.separatorChar != '/') {
                path.replace('/', File.separatorChar);
            }
            if ((index = path.lastIndexOf(File.separatorChar)) >= 0) {
                path = path.substring(0, index);
            }
            if (path.length() > 0) {
                path = path + File.separator;
            }
            this.m_fileName = path + name;
        }
        this.m_lastModified = null;
        if (oldFile != null) {
            return oldFile.renameTo(new File(this.getFullPath()));
        }
        return true;
    }

    public String getFileNamePart() {
        return this.m_fileNamePart;
    }

    public void setFileNamePart(String name) {
        this.m_fileNamePart = name;
    }

    public String getTitle(boolean bGuess) {
        String title = this.get(TITLE);
        if (title.length() > 0) {
            return title;
        }
        if (!bGuess) {
            return "";
        }
        title = this.getFileName();
        if (title.length() == 0) {
            return "";
        }
        title = title.replaceFirst("^[0-9]+[A-Z][-_ ]", "");
        title = title.replaceFirst("^[0-9]+[-_ ]", "");
        title = title.replace('_', ' ');
        title = title.replace('-', ' ');
        try {
            if (!(this instanceof DirectoryObject)) {
                title = title.replaceFirst("\\.[A-Za-z0-9_]+$", "");
            }
            title = title.replaceAll("%[0-9a-fA-F]{2}", " ");
            title = title.replaceAll("([a-z]{3,})([A-Z][a-z])", "$1 $2");
            StringTokenizer tokens = new StringTokenizer(title, " ");
            title = "";
            while (tokens.hasMoreTokens()) {
                String str = tokens.nextToken();
                if (title.length() == 0 && str.equalsIgnoreCase("x")) continue;
                if (title.length() == 0 || str.length() > 3) {
                    str = str.substring(0, 1).toUpperCase() + str.substring(1);
                }
                if (title.length() > 0) {
                    title = title + " ";
                }
                title = title + str;
            }
        }
        catch (Exception e) {
            System.err.println("E: GetTitle - Regular expression exception:\n" + e.toString());
        }
        return title;
    }

    public String getTitlePlain() {
        String str = this.getTitle(true);
        str = str.replaceAll("</?[A-Za-z][A-Za-z0-9_:-]* *[^>]*>", "");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&nbsp;", " ");
        str = str.replaceAll("&#15.;", "-");
        str = AbstractFSObject.transformAccents(str, false);
        str = str.replaceAll("&([A-Za-z])[A-Za-z0-9]*;", "$1");
        str = str.replaceAll("\n+", " ");
        str = str.replaceAll("  +", " ");
        str = str.trim();
        return str;
    }

    public static String transformAccents(String str, boolean bToHTML) {
        if (str == null) {
            return "";
        }
        for (int i = 0; i < CHAR_TAB.length; i += 2) {
            str = bToHTML ? str.replaceAll(CHAR_TAB[i], CHAR_TAB[i + 1]) : str.replaceAll(CHAR_TAB[i + 1], CHAR_TAB[i]);
        }
        return str;
    }

    public boolean isToExport() {
        if (this.getParent() != null && !this.getParent().isToExport()) {
            return false;
        }
        return this.m_bToExport;
    }

    public void setToExport(boolean bToExport) {
        this.m_bToExport = bToExport;
    }

    public int getConversionQuality() {
        int parentCQ = 0;
        if (this.getParent() != null) {
            parentCQ = this.getParent().getConversionQuality();
        }
        if (parentCQ != 0 && this.m_jpegQuality == 0) {
            return parentCQ;
        }
        return this.m_jpegQuality;
    }

    public void setConversionQuality(int quality) {
        this.m_jpegQuality = quality;
    }

    public void set(String name, String value) {
        if ((name = name.toLowerCase()).equals(DATE)) {
            StringTokenizer tokens = new StringTokenizer(value, "/");
            if (tokens.hasMoreTokens()) {
                this.set(DATE_BEGIN, tokens.nextToken());
            }
            if (tokens.hasMoreTokens()) {
                this.set(DATE_END, tokens.nextToken());
            }
        } else {
            this.m_properties.put(name, value);
        }
    }

    public String[] getUsedPropertyNames() {
        return this.m_properties.keySet().toArray(new String[0]);
    }

    public String get(String name) {
        if (name == DATE) {
            return this.getBeginDate(false) + "/" + this.getEndDate(false);
        }
        String val = this.m_properties.get(name);
        return val != null ? val.trim() : "";
    }

    public String getTransformed(String name, boolean bToHTML) {
        return AbstractFSObject.transformAccents(this.get(name), bToHTML);
    }

    public void remove(String name) {
        this.m_properties.remove(name);
    }

    public String toString() {
        String fileName = this.getFileName();
        if (fileName.length() > 0) {
            return fileName;
        }
        String s = this.getTransformed(TITLE, false);
        if (s.length() > 0) {
            return s;
        }
        if (this.m_fileNamePart.length() > 0) {
            return this.m_fileNamePart;
        }
        return "";
    }
}

