;----------------------------------------------------------------------
; Dirk Grossmann's Emacs initialization file
;======================================================================

; Set the icon and frame titles (%f file name, %b buffer name).
(setq frame-title-format "%b - Emacs")
(setq icon-title-format "%f")

; Make searches case-insensitive.
(set-default 'case-fold-search t)

; Display date and time in the border bar.
(setq display-time-24hr-format t)
(setq display-time-day-and-date t)
(setq scroll-bar-mode (quote right))
(setq make-backup-files nil)
(display-time)

; Display ISO Latin 1 characters.
(standard-display-european 1)

; Highlight matching parenthesis.
(show-paren-mode 1)

; Show the (empty) toolbar for the Brain button.
;(tool-bar-mode 1)

; Selection is overwritten with typed text.
(delete-selection-mode t)
(pc-selection-mode)

; Use CygWin ZIP for extracting files from archives.
(setq archive-zip-use-pkzip nil)

; Customize the frame layout.
;---------------------------------------------------------------------

(setq default-frame-alist
      '((top . 0) (left . 0)
        (width . 81) (height . 47)
        (cursor-color . "red")
        (cursor-type . box)
        (mouse-color . "white")
        (foreground-color . "black")
        (background-color . "white")
        (border-color . "#EEEEEE")
        (font . "-*-Fixedsys-normal-r-*-*-*-*-*-*-c-*-*-*")))

; Customized variables (written by Emacs M-x customize).
;---------------------------------------------------------------------

(custom-set-variables
  ;; custom-set-variables was added by Custom -- don't edit or cut/paste it!
  ;; Your init file should contain only one such instance.
 '(auto-image-file-mode t nil (image-file))
 '(blink-cursor-interval 0.4)
 '(blink-matching-paren-on-screen t)
 '(column-number-mode t)
 '(delete-old-versions t)
 '(make-backup-files nil)
 '(mouse-wheel-follow-mouse t)
 '(mouse-wheel-mode t nil (mwheel))
 '(speedbar-frame-parameters (quote ((minibuffer) (width . 30) (height . 47) (border-width . 0) (menu-bar-lines . 1) (unsplittable . t))))
 '(speedbar-show-unknown-files t)
 '(tab-width 4))

(custom-set-faces
  ;; custom-set-faces was added by Custom -- don't edit or cut/paste it!
  ;; Your init file should contain only one such instance.
 '(default ((t (:foreground "black" :background "white"))))
 '(bold ((t (:bold t))))
 '(bold-italic ((t (:foreground "goldenrod3" :slant italic :weight bold))))
 '(cursor ((t (:background "red" :foreground "white"))))
 '(custom-button-face ((t (:foreground "mediumvioletred" :box (:line-width 1 :color "grey75" :style released-button)))))
 '(custom-button-pressed-face ((((type x w32 mac) (class color)) (:background "lightgrey" :foreground "black" :box (:line-width 1 :style pressed-button)))))
 '(custom-documentation-face ((t (:foreground "darkslateblue"))))
 '(custom-state-face ((t (:foreground "OliveDrab4"))))
 '(fixed-pitch ((t (:family "courier new"))))
 '(font-lock-builtin-face ((t (:foreground "dodgerblue3"))))
 '(font-lock-comment-face ((t (:foreground "#339158"))))
 '(font-lock-constant-face ((t (:foreground "#006F42"))))
 '(font-lock-function-name-face ((t (:foreground "#000070"))))
 '(font-lock-keyword-face ((t (:foreground "#E6138C"))))
 '(font-lock-string-face ((t (:foreground "#2100A6"))))
 '(font-lock-type-face ((t (:foreground "#555588"))))
 '(font-lock-variable-name-face ((t (:foreground "#6F114B"))))
 '(fringe ((t (:background "#DDDDDD" :foreground "#3333FF"))))
 '(header-line ((((class color grayscale) (background light)) (:background "grey90" :foreground "black" :box (:line-width 1 :color "grey70" :style released-button)))))
 '(highlight ((((class color) (background light)) (:background "darkseagreen2" :box (:line-width 1 :color "grey75" :style released-button)))))
 '(info-menu-5 ((t (:foreground "goldenrod" :underline t))))
 '(info-node ((t (:foreground "goldenrod3" :slant italic :weight bold))))
 '(info-xref ((t (:foreground "goldenrod3" :weight bold))))
 '(isearch ((((class color) (background light)) (:background "palevioletred1" :foreground "brown4"))))
 '(isearch-lazy-highlight-face ((((class color) (background light)) (:background "paleturquoise3"))))
 '(mode-line ((t (:background "#555588" :foreground "white" :box (:line-width -1 :style released-button)))))
 '(region ((t (:background "gray80"))))
 '(secondary-selection ((t (:background "violet red2" :foreground "white"))))
 '(show-paren-match-face ((t (:background "turquoise4" :foreground "white"))))
 '(show-paren-mismatch-face ((((class color)) (:foreground "white" :background "purple3"))))
 '(speedbar-button-face ((t (:foreground "DarkOliveGreen3"))))
 '(variable-pitch ((t (:family "arial"))))
 '(vhdl-font-lock-clock-signal-face ((t (:foreground "indianred1"))))
 '(widget-button-face ((t (:foreground "skyblue3"))))
 '(widget-button-pressed-face ((t (:foreground "skyblue3" :box (:line-width 1 :color "grey75" :style pressed-button)))))
 '(widget-field-face ((t (:foreground "white" :background "slategray4")))))

; Enable Font Lock for all modes.
(cond ((fboundp 'global-font-lock-mode)
       ;; Load the font-lock package.
       (require 'font-lock)
       ;; Maximum colors.
       (setq font-lock-maximum-decoration t)
       ;; Turn on font-lock in all modes that support it.
       (global-font-lock-mode t)))

; PostScript printing.
;---------------------------------------------------------------------

(require 'ps-print)

; Set the printer name to your local port ("PRN") or "//host/printer".
(setq printer-name "//mybau1/schalom")
(setq ps-printer-name printer-name)

(setq ps-lpr-command "C:/Programme/Aladdin/gs6.01/bin/gswin32")

; The GhosScript options.
(setq ps-lpr-switches '("-q -sDEVICE=mswinpr2 -dNOPAUSE -IC:/Programme/Aladdin/gs6.01;C:/Aladdin/gs6.01/bin;C:/Aladdin/fonts"))

; Temporary spool.
(setq ps-lpr-buffer "~/spool/psspool.ps")      

;<We want syntax coloring> (setq ps-print-color-p nil)

(setq ps-paper-type 'a4)

; Margins (in pt).
(setq ps-left-margin 70)
(setq ps-right-margin 50)
(setq ps-top-margin 40)
(setq ps-bottom-margin 70)

; (setq ps-header-lines )
; (setq ps-show-n-of-n )
; (setq ps-left-header )
; (setq ps-right-header )

; Header settings.
(setq ps-print-header t)
(setq ps-print-header-frame t)
(setq ps-header-offset 30)
; (setq ps-font-family "Courier")
(setq ps-font-size 10)

(defun win32-ps-print-buffer ()
  (interactive)
  (ps-print-buffer ps-lpr-buffer)
  (shell-command
   (apply 'concat (append (list ps-lpr-command " ")
                          ps-lpr-switches
                          (list " " ps-lpr-buffer " -c quit")))))

; Additional Major Modes.
;---------------------------------------------------------------------

(setq auto-mode-alist (cons '("\\.idl\\'"  . c++-mode)  auto-mode-alist))
(setq auto-mode-alist (cons '("\\.odl\\'"  . c++-mode)  auto-mode-alist))
(setq auto-mode-alist (cons '("\\.rc\\'"   . c++-mode)  auto-mode-alist))
(setq auto-mode-alist (cons '("\\.asp\\'"  . html-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.jsp\\'"  . html-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.htx\\'"  . html-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.tmpl\\'" . html-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.tld\\'"  . html-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.js\\'"   . java-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.jj\\'"   . java-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("-j\\.jsp\\'" . java-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.mki\\'"  . makefile-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.pl\\'"   . perl-mode) auto-mode-alist))
(setq auto-mode-alist (cons '("\\.properties\\'" . makefile-mode) auto-mode-alist))

; Enable Python mode.
;(require 'python-mode)
;(setq auto-mode-alist (cons '("\\.py\\'"   . python-mode) auto-mode-alist))

; Enable PHP mode
(load-library "php-mode-102")
(setq auto-mode-alist (cons '("\\.php\\'"  . php-mode) auto-mode-alist))

; Enable Ruby mode
(load-library "ruby-mode")
(setq auto-mode-alist (cons '("\\.rb\\'"   . ruby-mode) auto-mode-alist))

;---------------------------------------------------------------------
; Code-Related Settings (by Galucci).
;=====================================================================

;; These setting are written in the order as described in the Emacs
;; info pages. ( Hit C-hi, then go to Emacs | Programs | Program
;; Indent | Custom C Indent | Syntactic Symbols for a description of
;; each. I found it easier to open one of my own source files, and
;; hit tab on a particular line to find the name of the syntactic
;; symbol. This assumes that the setting for 
;; c-echo-syntactic-information-p is not nil. )

(set-default 'indent-tabs-mode nil)

(defconst my-c-style
  '(
    (c-echo-syntactic-information-p . t)
    (c-basic-offset . 4)
    (c-toggle-auto-state . t)
    (c-offsets-alist .
                     ((string                . +)
                      (c                     . +)
                      (defun-open            . 0)
                      (defun-close           . 0)
                      (defun-block-intro     . +)
                      (class-open            . 0)
                      (class-close           . 0)
                      (inline-open           . 0)
                      (inline-close          . 0)
                      (extern-lang-open      . 0)
                      (extern-lang-close     . 0)
                      (func-decl-cont        . 0)
                      (knr-argdecl-intro     . +)
                      (knr-argdecl           . +)
                      (topmost-intro         . 0)
                      (topmost-intro-cont    . +)
                      (member-init-intro     . +)
                      (member-init-cont      . +)
                      (inher-intro           . +)
                      (inher-cont            . +)
                      (block-open            . 0)
                      (block-close           . 0)
                      (brace-list-open       . 0)
                      (brace-list-close      . 0)
                      (brace-list-intro      . +)
                      (brace-list-entry      . +)
                      (statement             . 0)
                      (statement-cont        . ++)
                      (statement-block-intro . +)
                      (statement-case-intro  . +)
                      (statement-case-open   . 0)
                      (substatement          . +)
                      (substatement-open     . 0)
;                      (case-label            . +)
                      (access-label          . -)
                      (label                 . 0)
                      (do-while-closure      . 0)
                      (else-clause           . 0)
                      (catch-clause          . 0)
                      (comment-intro         . 0)
                      (arglist-intro         . +)
                      (arglist-cont          . 0)
                      (arglist-cont-nonempty . +)
                      (arglist-close         . +)
                      (stream-op             . +)
                      (inclass               . +)
                      (inextern-lang         . +)
                      (cpp-macro             . 0)
                      (friend                . 0)
                      (objc-method-intro     . +)
                      (objc-method-args-cont . +)
                      (objc-method-call-cont . +)
                      ))

    (c-comment-only-line-offset . (0 . -1000))
    (c-hanging-braces-alist        . ((substatement-open after)
                                      (brace-list-open)))
    (c-hanging-colons-alist . ((member-init-intro before)
                               (inher-intro)
                               (case-label after)
                               (label after)
                               (access-label after)))
    (c-cleanup-list . (scope-operator
                       empty-defun-braces
                       defun-close-semi))
    )
  "Gallucci C++ Programming Style")

(defun my-c-mode-common-hook ()
  (c-add-style "Gallucci" my-c-style t)
  (c-set-offset 'member-init-intro '+)
  (setq tab-width 4
        indent-tabs-mode nil
        font-lock-maximum-decoration t)
  (c-toggle-auto-state t)
  (c-toggle-auto-hungry-state 1)
  (define-key c-mode-base-map "\C-j"   'newline-and-indent)
  (define-key c-mode-base-map "\C-m"   'newline-and-indent)
  (define-key c-mode-base-map [return] 'newline-and-indent)
  (define-key c-mode-base-map "\C-ci"  'indent-region)
  )

(add-hook 'c-mode-common-hook 'my-c-mode-common-hook)
(add-hook 'c++-mode-common-hook 'my-c-mode-common-hook)

;; Make the % key jump to the matching {}[]() if on another, like VI
;; (global-set-key "%" 'match-paren)      
;; (defun match-paren (arg)
;;   "Go to the matching parenthesis if on parenthesis otherwise insert %."
;;   (interactive "p")
;;   (cond ((looking-at "\\s\(") (forward-list 1) (backward-char 1))
;;         ((looking-at "\\s\)") (forward-char 1) (backward-list 1))
;;         (t (self-insert-command (or arg 1)))))

;---------------------------------------------------------------------
; CVS Settings.
;=====================================================================

(setq vc-make-backup-files nil)
(setq vc-cvs-stay-local nil)

;---------------------------------------------------------------------
; Load additional packages.
;=====================================================================

(require 'htmlize)

(global-set-key "\C-cs" 'speedbar-frame-mode)
(global-set-key "\C-c\C-g" 'goto-line)
(global-set-key "\C-cg" 'goto-line)

; Enable these commands without confirmation :-
(put 'upcase-region 'disabled nil)
(put 'downcase-region 'disabled nil)
